package com.sap.ip.me.mdk.api.awt.gui.panel.navigation;

import java.awt.Image;
import java.awt.event.MouseListener;

import com.sap.ip.me.mdk.api.awt.gui.panel.ImageNavPanel;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;
/**
 * Create the navigation bar to browse through a table. The buttons are page up and down, first page
 * and last page.
 */
public class PageNavPanel extends ImageNavPanel {

	private static Image enImgFirstRec = Utilities.getImage(Utilities.iconTopPage);
	private static Image enImgPrevRec = Utilities.getImage(Utilities.iconPrevPage);
	private static Image enImgNextRec = Utilities.getImage(Utilities.iconNextPage);
	private static Image enImgLastRec = Utilities.getImage(Utilities.iconLastPage);

	private static Image deImgFirstRec = Utilities.getImage(Utilities.iconTopPageOff);
	private static Image deImgPrevRec = Utilities.getImage(Utilities.iconPrevPageOff);
	private static Image deImgNextRec = Utilities.getImage(Utilities.iconNextPageOff);
	private static Image deImgLastRec = Utilities.getImage(Utilities.iconLastPageOff);

	private static Image[] enableImages = { enImgFirstRec, enImgPrevRec, enImgNextRec, enImgLastRec };
	private static Image[] disableImages = { deImgFirstRec, deImgPrevRec, deImgNextRec, deImgLastRec };

	public PageNavPanel() {
		this(null, null, null);
	}
	public PageNavPanel(MouseListener commonListener) {
		this(commonListener, null, null);
	}
	public PageNavPanel(MouseListener commonListener, String[] targetPages, String[] targetHandlers) {
		super(enableImages, disableImages, commonListener, targetPages, targetHandlers);
	}
}
