package com.sap.ip.me.mdk.api.awt.gui.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;

import com.sap.ip.me.mdk.api.awt.gui.component.BorderedPanel;
/**
 * Creates a navigation panel with text and sets the events.
 */
public class NavPanel extends Panel {

	private BorderedPanel centerPanel = null;
	private BorderedPanel leftPanel = null;
	private BorderedPanel rightPanel = null;

	public NavPanel() {
		this(null, null);
	}

	public NavPanel(Component[] left, Component[] right) {
		super(new BorderLayout());
		leftPanel = new BorderedPanel(new FlowLayout(FlowLayout.LEFT, 0, 0));
		leftPanel.enableBGDraw(true);
		leftPanel.enableBorderDraw(false);
		rightPanel = new BorderedPanel(new FlowLayout(FlowLayout.RIGHT, 0, 0));
		rightPanel.enableBGDraw(true);
		rightPanel.enableBorderDraw(false);
		centerPanel = new BorderedPanel(new FlowLayout(FlowLayout.CENTER, 0, 0));
		centerPanel.enableBGDraw(true);
		centerPanel.enableBorderDraw(false);
		add(BorderLayout.WEST, leftPanel);
		add(BorderLayout.EAST, rightPanel);
		add(BorderLayout.CENTER, centerPanel);
		if (left != null)
			addToLeft(left);
		if (right != null)
			addToRight(right);
	}

	public void addToLeft(Component[] c) {
		leftPanel.removeAll();
		for (int i = 0; i < c.length; i++)
			leftPanel.add(c[i]);
		validate();
	}
	public void addToRight(Component[] c) {
		rightPanel.removeAll();
		for (int i = 0; i < c.length; i++)
			rightPanel.add(c[i]);
		validate();
	}
	public void setBackground(Color c) {
		leftPanel.setBackgroundColor(c);
		centerPanel.setBackgroundColor(c);
		rightPanel.setBackgroundColor(c);
		repaint();
	}
}
