package com.sap.ip.me.mdk.api.awt.gui.panel;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;

import com.sap.ip.me.mdk.api.awt.gui.layout.TableLayout;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;

/**
 * Class to draw a header panel, containing an icon on the left hand side and a 
 * welcome text. The header panel is one row high.
 */
public class HeaderPanel extends Panel {

	private static Image image = null;
	private static Label userName = null;
	private static Font textFont = Utilities.fntBold11Dialog;
	private static Color bgColor = Utilities.lightYellowColor;

	public HeaderPanel(Image img) {
		super();
		image = img;
		double border = 1;
		double size[][] = { { 0.4, TableLayout.FILL }, // Columns
			{
				TableLayout.FILL, border }
		}; // Rows

		setLayout(new TableLayout(size));
		setBackground(bgColor);

		if (image != null)
			ensureImageLoaded(image);
	}
	/*
	 * Method to set a Welcome message in the header line (right aligned).
	 */
	public void setWelcomeText(String info) {
		userName = new Label(info, Label.RIGHT);
		userName.setForeground(Color.black);
		userName.setFont(textFont);
		add(userName, "1,0");
	}

	private final void ensureImageLoaded(Image image) {
		try {
			MediaTracker tracker = new MediaTracker(this);
			tracker.addImage(image, 0);
			tracker.waitForID(0);
		} catch (InterruptedException ex) {
		}
	}
	public void paint(Graphics g) {
		super.paint(g);
		if (isShowing()) {
			if (image != null) {
				int xPos = 1;
				int yPos = 1;
				g.drawImage(image, xPos, yPos, this);
			}
			g.setColor(Color.gray);
			g.drawLine(0, getSize().height - 1, getSize().width, getSize().height - 1);
		}
	}
	public void setIcon(String icon) {
		image = Utilities.getImage(icon);
	}
}
