package com.sap.ip.me.mdk.api.awt.gui.panel;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;

import com.sap.ip.me.mdk.api.awt.gui.layout.TableLayout;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;
/**
 * Footer panel can contain 2 text strings and is placed on the bottom of the 
 * MI application window
 */
public class FooterPanel extends Panel {

	private static Label lblAppVersion = null;
	private static Label lblPlace = null;
	private static Color bgColor = Utilities.menuBodyBGColor;
	private static Font  textFont = Utilities.fntPlain9Dialog;
	
	public FooterPanel(String appVersion){
		super();
		double border = 1;
  	double size[][] =
         {{TableLayout.PREFERRED,TableLayout.FILL},  // Columns
           {border,TableLayout.FILL}}; // Rows
		setLayout(new TableLayout(size));
		setBackground(bgColor);
		setAppVersionInfo(appVersion);
	}
	public void setAppVersionInfo(String vInfo){
		lblAppVersion = new Label(vInfo,Label.RIGHT);
		lblAppVersion.setFont(textFont);
		lblAppVersion.setForeground(Color.black);
		addLabel(lblAppVersion,"1,1");	
	}
	public void setPlaceInfo(String pInfo){
		lblPlace = new Label(pInfo,Label.LEFT);
		lblPlace.setFont(textFont);
		lblPlace.setForeground(Color.gray.darker());
		addLabel(lblPlace,"0,1");	
	}
	public void addLabel(Label lbl, String pos){
		this.add(lbl, pos);
		repaint();
	}
	public void paint(Graphics g){
		super.paint(g);
		if(isShowing()){
			g.setColor(Color.gray);
		  g.drawLine(0,0,getSize().width,0); 
		}
	}
}
