package com.sap.ip.me.mdk.api.awt.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Panel;

import com.sap.ip.me.mdk.api.awt.gui.component.BorderedPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.ListPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.layout.TableLayout;
import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;

/**
 * Creates a dialog panel
 */
public class DialogPanel extends Panel {

	private BorderedPanel titlePanel = null;
	private ListPanel listPanel = null;
	private TextLabel tlTitle = null;
	private static Font textFont = Utilities.fntBold11Dialog;
	private static Color titleBGColor = Utilities.headerBodyBGColor;
	private static Color titleColor = Utilities.headerTextColor;

	private BorderedPanel mnuPanel = null;

	public DialogPanel(String title) {
		super();

		double size[][] = { { 1, TableLayout.FILL, TableLayout.PREFERRED }, // Columns
			                {TableLayout.PREFERRED, TableLayout.PREFERRED, TableLayout.FILL }}; // Rows

		setLayout(new TableLayout(size));

		titlePanel = new BorderedPanel();
		titlePanel.enableBorderDraw(true);
		titlePanel.setBackgroundColor(titleBGColor);
		titlePanel.setLayout(new TableLayout(size));
		titlePanel.setBorderMask("TBLR");

		listPanel = new ListPanel();

		tlTitle = new TextLabel("");
		tlTitle.setFont(textFont);
		tlTitle.setTextColor(titleColor);

		titlePanel.add(tlTitle, "1,0");

		add(titlePanel, "1,0");
		add(listPanel, "1,1");

		setTitleBar(title);
	}
	public void addActionButton(LinkButton act) {
		titlePanel.add(act, "2,0");
	}
	public void setTitleBar(String title) {
		tlTitle.setLabel(title);
	}
	public void addLine(Component l) {
		listPanel.appendLine(l);
	}
	public void addLine(Component l, Component r) {
		listPanel.appendLine(l, r);
	}
	public void addLine(Component l, Component r[]) {
		listPanel.appendLine(l, r);
	}

}
