package com.sap.ip.me.mdk.api.awt.gui.page;

import java.awt.Component;

import com.sap.ip.me.mdk.api.awt.gui.component.ActionPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.MultiLabelPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.layout.TableLayout;
import com.sap.ip.me.mdk.api.awt.gui.panel.NavPanel;
import com.sap.ip.me.mdk.api.awt.gui.panel.navigation.TopNavLink;

/**
 * Creates a page with a description and an action bar and a table layout in the middle.
 */
public abstract class BasicPage extends AbstractMEPage {

	public static final String ATTR_PAGENAVMSG = "PAGENAVMSG";
	public static final String ATTR_NEWOBJECT = "NEWOBJECT";
	public static final String ATTR_CUROBJECT = "CURRENTOBJECT";
	public static final String ATTR_OBJECTLIST = "OBJECTLIST";
	public static final String ATTR_UNRESOLVEDOBJECT = "UNRESOLVEDOBJECT";
	public static final String ATTR_PARENTOBJECT = "PARENTOBJECT";

	protected MultiLabelPanel descHeader = null;
	protected ActionPanel actionBar = null;

	public BasicPage() {
		this(null);
	}

	public BasicPage(TopNavLink homeLink) {
		super();
		double size[][] = { { .02, TableLayout.FILL, .02 }, // Columns
			                {TableLayout.MINIMUM, TableLayout.PREFERRED, TableLayout.PREFERRED, 
			                 TableLayout.PREFERRED, 3, TableLayout.PREFERRED, 1 }}; // Rows
		setLayout(new TableLayout(size));

		descHeader = new MultiLabelPanel();
		actionBar = new ActionPanel();
		add(descHeader, "1,1"); //add the header description
		add(actionBar, "1,2"); //add the action panel
	}
	public void setTopLink(TopNavLink topLink) {
		if (topLink != null)
			add(topLink, "1,0"); //nav on top right
	}
	public void setHeaderTexts(String[] texts) {
		descHeader.setTexts(texts);
		validate();
	}
	public void setSubActionLinks(LinkButton[] links) {
		if (links != null && links.length > 0)
			actionBar.addToLeft(links);
	}
	public void setActionBarMessage(String message) {
		TextLabel[] msgText = { new TextLabel(message)};
		actionBar.addToLeft(msgText);
		validate();
	}
	public void setActionBarLinks(LinkButton[] links) {
		if (links != null && links.length > 0)
			actionBar.addToRight(links);
	}
	public void setFooterNavBar(NavPanel navPanel) {
		if (navPanel != null)
			add(navPanel, "1,5");
	}
	public void setBody(Component bodyForm) {
		if (bodyForm != null) {
			add(bodyForm, "1,3");
		}
	}

	abstract public void initializePage();

	abstract public void destroyPage();

	abstract public void updatePage();
}
