package com.sap.ip.me.mdk.api.awt.gui.layout;
/**
 * Constants for the MI table layout
 */
public interface TableLayoutConstants {

	/** Constant to align a component to the left of the cell */
	public static final int LEFT = 0;

	/** Constant to align a component to the top of the cell */
	public static final int TOP = 0;

	/** Constant to align a component centered of the cell */
	public static final int CENTER = 1;

	/** Constant to full align a component in the cell */
	public static final int FULL = 2;

	/** Constant to align a component to the bottom of the cell */
	public static final int BOTTOM = 3;

	/** Constant to align a component to the right of the cell */
	public static final int RIGHT = 3;

	/** Constant to fill a component into the available space of the cell */
	public static final double FILL = -1.0;

	/** The row/column should be allocated just enough space to
	    accomidate the preferred size of all components contained completely within
	    this row/column. */
	public static final double PREFERRED = -2.0;

	/** The row/column should be allocated just enough space to
	    accomidate the minimum size of all components contained completely within
	    this row/column. */
	public static final double MINIMUM = -3.0;

	/** Minimum value for an alignment */
	public static final int MIN_ALIGN = 0;

	/** Maximum value for an alignment */
	public static final int MAX_ALIGN = 3;

}
