package com.sap.ip.me.mdk.api.awt.gui.layout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;
/**
 * Basic implements of the AWT LayoutManager. It is used by the ParagraphLayout method, which is used to 
 * add text lines.
 */
public class ConstraintLayout implements LayoutManager2 {
	protected final static int PREFERRED = 0;
	protected final static int MINIMUM = 1;
	protected final static int MAXIMUM = 2;

	protected int hMargin = 0;
	protected int vMargin = 0;
	private Hashtable constraints;
	protected boolean includeInvisible = false;

	public void addLayoutComponent(String constraint, Component c) {
		setConstraint(c, constraint);
	}

	public void addLayoutComponent(Component c, Object constraint) {
		setConstraint(c, constraint);
	}

	public void removeLayoutComponent(Component c) {
		if (constraints != null)
			constraints.remove(c);
	}

	public void setConstraint(Component c, Object constraint) {
		if (constraint != null) {
			if (constraints == null)
				constraints = new Hashtable();
			constraints.put(c, constraint);
		} else if (constraints != null)
			constraints.remove(c);
	}

	public Object getConstraint(Component c) {
		if (constraints != null)
			return constraints.get(c);
		return null;
	}

	public void setIncludeInvisible(boolean includeInvisible) {
		this.includeInvisible = includeInvisible;
	}

	public boolean getIncludeInvisible() {
		return includeInvisible;
	}

	protected boolean includeComponent(Component c) {
		return includeInvisible || c.isVisible();
	}

	public Dimension minimumLayoutSize(Container target) {
		return calcLayoutSize(target, MINIMUM);
	}

	public Dimension maximumLayoutSize(Container target) {
		return calcLayoutSize(target, MAXIMUM);
	}

	public Dimension preferredLayoutSize(Container target) {
		return calcLayoutSize(target, PREFERRED);
	}

	public Dimension calcLayoutSize(Container target, int type) {
		Dimension dim = new Dimension(0, 0);
		measureLayout(target, dim, type);
		Insets insets = target.getInsets();
		dim.width += insets.left + insets.right + 2 * hMargin;
		dim.height += insets.top + insets.bottom + 2 * vMargin;
		return dim;
	}

	public void invalidateLayout(Container target) {
	}

	public float getLayoutAlignmentX(Container parent) {
		return 0.5f;
	}

	public float getLayoutAlignmentY(Container parent) {
		return 0.5f;
	}

	public void layoutContainer(Container target) {
		measureLayout(target, null, PREFERRED);
	}

	public void measureLayout(Container target, Dimension dimension, int type) {
	}

	protected Dimension getComponentSize(Component c, int type) {
		if (type == MINIMUM)
			return c.getMinimumSize();
		if (type == MAXIMUM)
			return c.getMaximumSize();
		return c.getPreferredSize();
	}
}
