package com.sap.ip.me.mdk.api.awt.gui.component;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;

import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;

/**
 * Generates a panel with multiple text entries and specified background color. 
 * Fro example used by the top navigation.
 */
public class MultiLabelPanel extends Panel {

	private TextLabel[] lab = null;
	private Font tFont =  Utilities.fntBold11Dialog;
	private Color tColor = Utilities.headerTextColor;
	private Color bgColor =Utilities.headerBodyBGColor;

	public MultiLabelPanel() {
		this(null);
	}

	public MultiLabelPanel(String[] texts) {
		super(new GridLayout(0,1));
		setTexts(texts);
		this.setBackground(bgColor);
	}
	public void setTextFont(Font f){
		tFont = f;
		repaint();
	}
	public void setTextColor(Color c){
		tColor = c;
		repaint();
	}
	public void setTexts(String[] texts){
		if(texts == null) return;
		invalidate();
		removeAll();
		lab = new TextLabel[texts.length];
		for(int i=0; i<lab.length; i++){
			lab[i] = new TextLabel(texts[i]);
			lab[i].setFont(tFont);
			lab[i].setTextColor(tColor);
			add(lab[i]);
		}
		validate();
	}
}