*&---------------------------------------------------------------------*
*& Report  MDK_SST_CONTACT_CREATE_UNITTST
*&
*&---------------------------------------------------------------------*
*& Unit test for Contact Create Bapi Wrapper in
*& Smart Sync Tutorial of MDK
*&---------------------------------------------------------------------*

REPORT  mdk_sst_contact_create_unittst.

PARAMETERS: lastname LIKE merep_person-last_name OBLIGATORY.

DATA: ls_person    LIKE merep_person ,
      lf_p_number  LIKE merep_person-persnumber ,
      lt_address   LIKE merep_address OCCURS 0 ,  "never filled
      lt_e_mail    LIKE merep_e_mail OCCURS 0 ,   "never filled
      ls_return_c  TYPE bapiret2 ,
      ls_return_g  TYPE bapiret2 ,
      err_txt1(50) TYPE c,
      err_txt2(50) TYPE c,
      err_txt3(50) TYPE c.

* Fill mandatory values for create
ls_person-last_name = lastname .

* Call 'CREATE' BAPI Wrapper
CALL FUNCTION 'MEREP_CONTACT_CREATE'
  EXPORTING
    person     = ls_person
  IMPORTING
    persnumber = lf_p_number
    return     = ls_return_c
  TABLES
    address    = lt_address    "<== null
    e_mail     = lt_e_mail.    "<== null

* Validate CREATE call
IF ls_return_c-type = 'E' OR
   ls_return_c-type EQ 'A' .
  err_txt1 = 'Error message from Create call'.
ELSE.
  err_txt1 = 'No Error message from Create call'.
ENDIF .

IF lf_p_number IS INITIAL.
  err_txt2 = 'Created Number not returned'.
ELSE.
  err_txt2 = lf_p_number.
ENDIF .
* Call 'GetDetail' BAPI Wrapper
CALL FUNCTION 'MEREP_CONTACT_GETDETAIL'
  EXPORTING
    persnumber = lf_p_number  "<== just created...
  IMPORTING
    person     = ls_person
    return     = ls_return_g
  TABLES
    address    = lt_address    "==> null
    e_mail     = lt_e_mail.    "==> null

* Validate GetDetail call
IF ls_return_g-type = 'E' OR
   ls_return_g-type = 'A'.
  err_txt3 = 'GetDetail BAPI did not find entry just created'.
ELSE.
  err_txt3 = 'No Error Message from GetDetail Call'.
ENDIF .

* Display results
WRITE: /'Create Call Results:' , / err_txt1 , / err_txt2.
WRITE: /'GetDetail Call Results:' , / err_txt3 .
