/*
 * Relational_4.java
 * 
 * Copyright 2004-2005 by SAP AG. All Rights Reserved.
 * SAP, R/3, mySAP, mySAP.com, xApps, xApp, SAP NetWeaver, and other SAP 
 * products and services mentioned herein as well as their respective logos 
 * are trademarks or registered trademarks of SAP AG in Germany and in several 
 * other countries all over the world. All other product and service names 
 * mentioned are the trademarks of their respective companies. Data contained 
 * in this document serves informational purposes only. National product 
 * specifications may vary.
 *
 * These materials are subject to change without notice. These materials are 
 * provided by SAP AG and its affiliated companies ("SAP Group") for 
 * informational purposes only, without representation or warranty of any kind, 
 * and SAP Group shall not be liable for errors or omissions with respect to 
 * the materials. The only warranties for SAP Group products and services are 
 * those that are set forth in the express warranty statements accompanying 
 * such products and services, if any. Nothing herein should be construed as 
 * constituting an additional warranty.
 */
package com.sap.ip.bi.sdk.samples;

import java.io.IOException;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.omg.cwm.resource.relational.Column;
import org.omg.cwm.resource.relational.Table;

import com.sap.exception.IBaseException;
import com.sap.ip.bi.sdk.dac.connector.IBIConnection;
import com.sap.ip.bi.sdk.dac.connector.IBIRelational;
import com.sap.ip.bi.sdk.dac.relational.query.IBICommandProcessor;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQuery;
import com.sap.ip.bi.sdk.samples.servlet.MinimalServletContainer;

/**
 * Simple relational query -
 *
 * Demonstrates how to retrieve a result set by creating a simple
 * query, then shows how to display the result set as an HTML table.
 *
 * View the HTML rendered by this servlet in the following file:
 * [SDK archive]/docs/examples/relational_4.result.html
 *
 * @author  SAP
 * @version 3.50
 * @since   3.50
 */
public class Relational_4 extends HttpServlet {
  private final static String CONTENT_TYPE = "text/html";

  public void init(ServletConfig config) throws ServletException {
    super.init(config);
  }

  public void doGet(
    HttpServletRequest request,
    HttpServletResponse response)
    throws ServletException, IOException {

    response.setContentType(CONTENT_TYPE);
    PrintWriter out = response.getWriter();

    out.println(Helpers.getDocTypeDefinition());
    out.println("<html>");
    out.println("<head><title>Relational_4</title>");
    out.println(Helpers.getStyleSheetDefinition());
    out.println("</head><body>");

    try {

      // ********************************************************
      // Connect to a data source.
      // ********************************************************
      IBIConnection connection =
        Helpers.connectToJDBCDatasource(out);
      IBIRelational rel = connection.getRelational();

      // create JDBC sample data where needed
      Helpers.createJDBCSampleData();

      // ********************************************************
      // Retrieve the metadata.
      // ********************************************************
      List tables =
        rel.getObjectFinder().findTable(
          (String) null,
          null,
          "%CUSTOMERS");
      if (tables == null || tables.size() < 1) {
        throw new ServletException("metadata access failed");
      }
      Table customer = (Table) tables.get(0);
      List columns = customer.getFeature();

      // ********************************************************
      // Create the query.
      // ********************************************************
      // create query instance
      IBIQuery query = rel.createQuery();
      // create command processor for this query instance
      IBICommandProcessor cp = query.getCommandProcessor();
      // add the table
      String tref = cp.addTable(customer);
      // add all columns
      for (Iterator i = columns.iterator(); i.hasNext();) {
        Column column = (Column) i.next();
        cp.addColumn(column, tref);
      }
      // execute the query
      ResultSet res = query.execute();
      
      // show the executed SQL statement
      out.println("<p><b>SQL Statement that was executed:</b><br>");
      out.println(
          "<code>"
            + rel.getNativeRepresentation(query)
            + "</code>");

      // ********************************************************
      // Render the result set.
      // ********************************************************
      Helpers.renderResultset(out, res);

    } 
    // Catch errors.
    catch (Exception e) {
      // $JL-EXC$
      e.printStackTrace();
      if (e instanceof IBaseException)
        out.println("Error: " +
                ((IBaseException)e).getNestedLocalizedMessage());
      else  
        out.println("Error: " + e.getMessage());        
    }
    out.println("</body>");
    out.println("</html>");
  }

  public void destroy() {
  }

  public static void main(String[] args) {
    if (args.length == 1) {
      MinimalServletContainer.executeServlet(new Relational_4(), args[0]);
    } else {
      MinimalServletContainer.executeServlet(new Relational_4(), System.out);
    }

  }

}
