/*
 * Olap_8.java
 *
 * Copyright 2004-2005 by SAP AG. All Rights Reserved.
 * SAP, R/3, mySAP, mySAP.com, xApps, xApp, SAP NetWeaver, and other SAP 
 * products and services mentioned herein as well as their respective logos 
 * are trademarks or registered trademarks of SAP AG in Germany and in several 
 * other countries all over the world. All other product and service names 
 * mentioned are the trademarks of their respective companies. Data contained 
 * in this document serves informational purposes only. National product 
 * specifications may vary.
 *
 * These materials are subject to change without notice. These materials are 
 * provided by SAP AG and its affiliated companies ("SAP Group") for 
 * informational purposes only, without representation or warranty of any kind, 
 * and SAP Group shall not be liable for errors or omissions with respect to 
 * the materials. The only warranties for SAP Group products and services are 
 * those that are set forth in the express warranty statements accompanying 
 * such products and services, if any. Nothing herein should be construed as 
 * constituting an additional warranty.
 */
package com.sap.ip.bi.sdk.samples;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sap.exception.IBaseException;
import com.sap.ip.bi.sdk.dac.connector.IBIConnection;
import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.olap.query.IBICommandProcessor;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIQuery;
import com.sap.ip.bi.sdk.samples.servlet.MinimalServletContainer;

/**
 * Hierarchy navigation - member drill operations -
 *
 * Illustrates hierarchy navigation by applying the following
 * operations in sequence to an initial data set:
 *
 * 1. zoom in
 * 2. zoom out
 * 3. drill down
 * 4. drill up
 *
 * After each operation, the result set is rendered again for
 * comparison.
 *
 * View the HTML rendered by this servlet in the following file:
 * [SDK archive]/docs/examples/olap_8.result.html
 *
 * @author  SAP
 * @version 3.50
 * @since 3.50
 */
public class Olap_8 extends HttpServlet {
  private static final String CONTENT_TYPE = "text/html";

  public void init(ServletConfig config) throws ServletException {
    super.init(config);
  }

  public void doGet(
    HttpServletRequest request,
    HttpServletResponse response)
    throws ServletException, IOException {

    response.setContentType(CONTENT_TYPE);
    PrintWriter out = response.getWriter();

    out.println(Helpers.getDocTypeDefinition());
    out.println("<html>");
    out.println("<head><title>Olap_8</title>");
    out.println(Helpers.getStyleSheetDefinition());
    out.println("</head><body>");

    try {
      // ********************************************************
      // Connect to data source.
      // ********************************************************
      IBIConnection connection =
        Helpers.connectToXMLADatasource(out);

      // ********************************************************
      // Retrieve metadata.
      // ********************************************************
      // Get Olap interface
      IBIOlap olap = connection.getOlap();
      Helpers.SampleMetaDataBW sampleMetaData =
        Helpers.getSampleMetaDataBW(connection);

      // ********************************************************
      // Create query and command processor.
      // ********************************************************
      IBIQuery query = olap.createQuery(sampleMetaData.cube);
      IBICommandProcessor commandProcessor =
        query.getCommandProcessor();

      // ********************************************************
      // Change the layout.
      // ********************************************************
      // Move the "0D_DIS_CHAN" Dimension to rows
      commandProcessor.moveDimensionToRows(
        sampleMetaData.distributionChannelDimension);

      // ********************************************************
      // Specify selected members.
      // ********************************************************
      commandProcessor.addMember(
        sampleMetaData.divisionHiTechMember);
      commandProcessor.addMember(
        sampleMetaData.distributionChannelAll);
      commandProcessor.addMember(
        sampleMetaData.valueTypeActualMember);
      commandProcessor.addMember(
        sampleMetaData.versionCurrentMember);
      commandProcessor.addMember(
        sampleMetaData.measuresQuantityMember);
      commandProcessor.addMember(
        sampleMetaData.measuresCostMember);

      Helpers.renderQueryAndDataset(out, query);

      // zoom in
      commandProcessor.zoomInMember(
        sampleMetaData.distributionChannelAll);
      Helpers.renderQueryAndDataset(out, query);

      // zoom out
      commandProcessor.zoomOutMember(
        sampleMetaData.distributionChannelDirectSales);
      Helpers.renderQueryAndDataset(out, query);

      // drill down
      commandProcessor.drillDownMember(
        sampleMetaData.distributionChannelAll);
      Helpers.renderQueryAndDataset(out, query);

      // drill up
      commandProcessor.drillUpMember(
        sampleMetaData.distributionChannelAll);
      Helpers.renderQueryAndDataset(out, query);

    } 
    // Catch errors.
    catch (Exception e) {
      // $JL-EXC$
      e.printStackTrace();
      if (e instanceof IBaseException)
        out.println("Error: " +
                ((IBaseException)e).getNestedLocalizedMessage());
      else  
        out.println("Error: " + e.getMessage());        
    }
    out.println("</body>");
    out.println("</html>");
  }

  public void destroy() {
  }

  public static void main(String[] args) {

    if (args.length == 1) {
      MinimalServletContainer.executeServlet(new Olap_8(), args[0]);
    } else {
      MinimalServletContainer.executeServlet(new Olap_8(), System.out);
    }
  }

}
