/*
 * Created on Mar 23, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.caf.km.datasvc.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

/**
 * @author D040882
 * @author C5047333 (viachaslau_kudzinau@epam.com) 
 */
public class TypeConstants {
	
	public static final String TYPE_INTEGER = "Integer";
	public static final String TYPE_LONG = "Long";
	public static final String TYPE_BOOLEAN = "Boolean";
	public static final String TYPE_STRING = "String";
	public static final String TYPE_DATE = "Date";
	
	private static final String EMPTY_STRING = ""; 
	private static final String EMPTY_DATE = String.valueOf(new Date(0).getTime());
	private static final String EMPTY_BOOLEAN = String.valueOf(Boolean.FALSE);
	private static final String EMPTY_LONG = String.valueOf(0);
	private static final String EMPTY_INTEGER = String.valueOf(0);
	
	private static final Collection SUPPORTED_INTEGER = new ArrayList();
	private static final Collection SUPPORTED_LONG = new ArrayList();
	private static final Collection SUPPORTED_BOOLEAN = new ArrayList();
	private static final Collection SUPPORTED_STRING = new ArrayList();
	private static final Collection SUPPORTED_DATE = new ArrayList();

	private static final Object[][] TYPES = {
			{SUPPORTED_LONG, TYPE_LONG}, // less frequently used
			{SUPPORTED_INTEGER, TYPE_INTEGER}, 
			{SUPPORTED_BOOLEAN, TYPE_BOOLEAN}, 
			{SUPPORTED_DATE, TYPE_DATE},
			{SUPPORTED_STRING, TYPE_STRING} // most frequently used
		};
	
	static {
		// init type consts
		SUPPORTED_LONG.add(Long.class);
		SUPPORTED_LONG.add(long.class);		
		SUPPORTED_INTEGER.add(Integer.class);
		SUPPORTED_INTEGER.add(int.class);
		SUPPORTED_BOOLEAN.add(Boolean.class);
		SUPPORTED_BOOLEAN.add(boolean.class);
		SUPPORTED_DATE.add(Date.class);
		SUPPORTED_STRING.add(String.class);
	}
	
	public static String getType(Class attrClass) {
		String type = TYPE_STRING;
		if (attrClass!=null) { 
			for(int i=TYPES.length; --i>=0; ) {
				for(Iterator itr=((Collection)TYPES[i][0]).iterator(); itr.hasNext();) {
					if (((Class)itr.next()).isAssignableFrom(attrClass)) {
						return (String)TYPES[i][1];
					}
				}
			}
		}
		return type;
	}
	
	public static String convertToString(String type, Object property) {
		if (TYPE_STRING.equals(type)) {
			return property==null? EMPTY_STRING: String.valueOf(property);
		}
		else if (TYPE_DATE.equals(type)) {
			return property==null? EMPTY_DATE: String.valueOf(((Date)property).getTime());
		}
		else if (TYPE_BOOLEAN.equals(type)) {
			return property==null? EMPTY_BOOLEAN: String.valueOf(property);
		}
		else if (TYPE_INTEGER.equals(type)) {
			return property==null? EMPTY_INTEGER: String.valueOf(property);
		}
		else if (TYPE_LONG.equals(type)) {
			return property==null? EMPTY_LONG: String.valueOf(property);
		}
		else {
			throw new RuntimeException("Unsupported type");
		}
	}
}
