package com.sap.caf.km.datasvc.ejb;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

import com.sap.caf.km.datasvc.data.BO;
import com.sap.caf.km.datasvc.data.BODescription;
import com.sap.caf.km.datasvc.data.BOInstance;
import com.sap.caf.km.datasvc.data.Relation;
import com.sap.caf.km.datasvc.exceptions.AccessDeniedException;
import com.sap.caf.km.datasvc.exceptions.DataServiceWSException;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;

/**
 * @ejbHome <{BOBrwoserHome}>
 * @ejbLocal <{BOBrwoserLocal}>
 * @ejbLocalHome <{BOBrwoserLocalHome}>
 * @ejbRemote <{BOBrwoser}>
 * @stateless 
 */
public class CAFDataServiceBean implements SessionBean {
	private static final String jARMRequest = "CAF:RT:cafdataservice";
	private static final Location location = Location.getLocation(CAFDataServiceBean.class);
	 
	private transient com.sap.caf.km.datasvc.CAFDataServiceImpl browser=null;

	public void ejbRemove() {
		String method = "ejbRemove()";		
		CAFPublicLogger.entering(null, jARMRequest, method, location, new Object[0]);		
		
		CAFPublicLogger.exiting(null, jARMRequest, method,location);
	}

	public void ejbActivate() {
		String method = "ejbActivate()";		
		CAFPublicLogger.entering(null, jARMRequest, method, location, new Object[0]);		
		
		CAFPublicLogger.exiting(null, jARMRequest, method,location);
	}

	public void ejbPassivate() {
		String method = "ejbPassivate()";		
		CAFPublicLogger.entering(null, jARMRequest, method, location, new Object[0]);		
		
		CAFPublicLogger.exiting(null, jARMRequest, method,location);
	}

	public void setSessionContext(SessionContext context) {
		String method = "setSessionContext(SessionContext)";		
		CAFPublicLogger.entering(null, jARMRequest, method, location, new Object[] {context});		
		
		myContext = context;
		
		CAFPublicLogger.exiting(null, jARMRequest, method,location);		
	}

	private transient SessionContext myContext;

	/**
	 * Create Method.
	 */
	public void ejbCreate() throws CreateException {
		String method = "ejbCreate()";
		CAFPublicLogger.entering(null, jARMRequest, method, location, new Object[0]);
		
		try {
			browser = new com.sap.caf.km.datasvc.CAFDataServiceImpl();
		}
		catch(DataAccessException e) {        	
			throw new CreateException("Could not initialize caf data service");	
		}
		
		CAFPublicLogger.exiting(null, jARMRequest, method,location);		
	}

	public BODescription[] getAllBOs() throws DataServiceWSException {
		String method = "getAllBOs()";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[0]);

		BODescription[] tmp = new BODescription[0];		
		
		try {			
			tmp = browser.getAllBOs();
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);
		}
		CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);		
		
		return tmp;
	}
	
	public Relation[] getAssociatedBOs(String guidBO) 
									throws DataServiceWSException {
		String method = "getAssociatedBOs(String)";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[] {guidBO});		
					
		Relation[] tmp=new Relation[0];
		try {
			tmp = browser.getAssociatedBOs(guidBO);
		}
		catch(DataAccessException ex) {	
			throw new DataServiceWSException(ex);
		}
		CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);
		return tmp;
	}
	
	public Relation[] getAggregatedBOs(String guidBO)
								 throws DataServiceWSException {
		String method = "getAggregatedBOs(String)";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[] {guidBO});		
				
		Relation[] tmp=new Relation[0];
		try {
			tmp = browser.getAggregatedBOs(guidBO);
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);
		}
		
		CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);		
		return tmp;
	}
	
	public BO getBO(String provider, String application, String bo)
								 throws DataServiceWSException {

		String method = "getBO(String, String, String)";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[] {provider, application, bo});		

		BO tmp = null;		
		
		try {			
			tmp = browser.getBO(provider, application, bo);	
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);
		}

		CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);
		return tmp;	
	}
	
	public BO getBOByGUID(String guid)
						throws DataServiceWSException {
	
		String method = "getBOByGUID(String)";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[] {guid});		

		BO tmp = null;		
		
		try {			
			tmp = browser.getBOByGUID(guid);	
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);
		}

		CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);
		return tmp;				
	}
		
	public BOInstance getBOInstance(String guidBO, String guidInstance)
										 throws DataServiceWSException, AccessDeniedException {

		String method = "getBOInstance(String, String)";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[] {guidBO, guidInstance});		

		BOInstance tmp=null;
		
		try {
			tmp=browser.getBOInstance(guidBO, guidInstance);
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);	
		}
		catch(CAFPermissionException ex4) {
			throw new AccessDeniedException("Access denied");
		}

		CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);		
		return tmp;
	}
	
	public String[] getInstancesByGUIDPart(String guidBO, String guidPart)
										throws DataServiceWSException {

		String method = "getInstancesByGUIDPart(String, String)";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[] {guidBO, guidPart});		
		
		String[] guids=null;
		try {
			guids=browser.getInstancesByGUIDPart(guidBO, guidPart);
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);	
		}

		CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);
		return guids;						
	}
	
	public String[] getRelatedInstancesByGUIDPart(String guidBO, String guidRelation, String guidInstance, String guidPart)
										throws DataServiceWSException {
		String method = "getRelatedInstancesByGUIDPart(String, String, String, String)";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[] {guidBO, guidRelation, guidInstance, guidPart});		

		String[] guids=null;
		try {
			guids=browser.getRelatedInstancesByGUIDPart(guidBO, guidRelation, guidInstance, guidPart);
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);	
		}

		CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);
		return guids;						
	}

	public BO getRelatedBOByRelationGUID(String relationGuid)
				throws DataServiceWSException {

		String method = "getRelatedBOByRelationGUID(String)";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[] {relationGuid});		

		BO bo=null;
		try {
			bo=browser.getRelatedBOByRelationGUID(relationGuid);
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);	
		}
		finally {		
			CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);
		}

		return bo;											
	}
	
	public String[] getPopulatedFolders(String guid, int noDigits, String startGuid)
						 throws DataServiceWSException {
		String method = "getPopulatedFolders(String, int, String)";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[] {guid, new Integer(noDigits), startGuid});		

		String[] guids=null;
		try {
			guids=browser.getPopulatedFolders(guid, noDigits, startGuid);
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);	
		}
		finally {
			CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);	
		}

		return guids;		
	}

	public String[] getRelatedPopulatedFolders(String guidBO, String guidRelation, String guidInstance, 
										int digits, String guidPart) throws DataServiceWSException {
		
		String method = "getRelatedPopulatedFolders(String, String, String, int, String)";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, 
										new Object[] {guidBO, guidRelation, guidInstance, new Integer(digits), guidPart});		

		String[] guids=null;
		try {
			guids=browser.getRelatedPopulatedFolders(guidBO, guidRelation, guidInstance, digits, guidPart);
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);	
		}
		finally {
			CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);
		}
			
		return guids;
	}

	public Relation[] getComplexAttributes(String guidBO, String[] guidRelation)
				throws DataServiceWSException {

		String method = "getComplexAttributes(String, String[])";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[] {guidBO, guidRelation});		
		
		Relation[] tmp = new Relation[0];		
		
		try {			
			tmp = browser.getComplexAttributes(guidBO, guidRelation);	
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);
		}
		finally {
			CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);		
		}
		
		return tmp;
	}

	public String[] getComplexAttributeInstances(String guidBO, String guidInstance, String[] guidRelation, String[] guidDOInstance)
				throws DataServiceWSException {

		String method = "getComplexAttributeInstances(String, String, String[], String[])";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, 
												new Object[] {guidBO, guidInstance, guidRelation, guidDOInstance});		

		String[] tmp = new String[0];		
		
		try {			
			tmp = browser.getComplexAttributeInstances(guidBO, guidInstance, guidRelation, guidDOInstance);	
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);
		}
		finally {
			CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);		
		}	
		
		return tmp;
	}

	public BO getComplexAttribute(String guidDO)
				throws DataServiceWSException {

		String method = "getComplexAttribute(String)";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[] {guidDO});		

		BO tmp =null;		
		
		try {			
			tmp = browser.getComplexAttribute(guidDO);	
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);
		}
		finally {
			CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);		
		}
		
		return tmp;						
	}

	public BOInstance getComplexAttributeInstance(String guidBO, String guidBOInstance, String[] guidRelation, String[] guidDOInstance)
				throws DataServiceWSException, AccessDeniedException {

		String method = "getComplexAttributeInstance(String, String, String[], String[]";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, 
								new Object[] {guidBO, guidBOInstance, guidRelation, guidDOInstance});		

		BOInstance tmp=null;
		
		try {
			tmp=browser.getComplexAttributeInstance(guidBO, guidBOInstance, guidRelation, guidDOInstance);
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);	
		}
		catch(CAFPermissionException ex4) {
			throw new AccessDeniedException("Access denied");
		}
		finally {
			CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);
		}
				
		return tmp;
	}
	
	public String[] getRelatedKMObjects(String fullBOName) 
					throws DataServiceWSException {
		String method = "getRelatedKMObjects(String)";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[] {fullBOName});		
		
		String[] tmp=null;
		try {
			tmp=browser.getRelatedKMObjects(fullBOName);
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);	
		}
		finally {
			CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method,location);		
		}
				
		return tmp;							
	}
	
	public boolean[] checkRights(String guidBO, String guidInstance, String[] rightsToCheck) throws DataServiceWSException, AccessDeniedException {
		String method = "checkRights(String, String, String[])";
		CAFPublicLogger.entering(myContext.getCallerPrincipal().getName(), jARMRequest, method, location, new Object[] {guidBO, guidInstance, rightsToCheck});		

		boolean[] tmp=null;
		
		try {			
			tmp=browser.checkRights(guidBO, myContext.getCallerPrincipal().getName(), guidInstance, rightsToCheck);
		}
		catch(DataAccessException ex) {
			throw new DataServiceWSException(ex);	
		}
		finally {
			CAFPublicLogger.exiting(myContext.getCallerPrincipal().getName(), jARMRequest, method, location);		
		}		
				
		return tmp;			
	}
	
	public boolean isConnectionLoopbackAlive() throws DataServiceWSException {
			return true;
	}
}

