package com.sap.caf.km.datasvc.data;


/**
 * @author d040882
 *
 * Dataholder class for an instance of a business object. It stores all necessary data of
 * the instance. It is used to be passed as parameter in the webservice.
 */
public class BOInstance implements java.io.Serializable {	
	private String guidBO=null;
	private String providerBO=null;
	private String appBO=null;
	private String idBO=null;

	private String instanceKEY=null;

	//this attribute is only valid (!=null) if this business object was
	//requested as part of a relation
	//in this case the attribute represents the name of the source role
	//for the relation
	private String roleBO=null;
	private int relationType=0;	
	
	private long createdAt=0;
	private long lastChangedAt=0;	
	private String createdBy=null;
	private String lastChangedBy=null;
	
	private int backend=0;
	private Attribute[] attributes=null;
	private Attribute[] categories=null;
	
	private String displayName=null;
	private String description=null;
	
	
	public BOInstance(BO bo, String guidInstance) {
		this(bo.getGuidBO(), bo.getProviderBO(), bo.getAppBO(), bo.getIdBO(), guidInstance);
	}
	
	public BOInstance(String guidBO, String provider, String application,String id, String guidInstance) {
		this.guidBO=guidBO;
		this.providerBO=provider;
		this.appBO=application;
		this.idBO=id;
		
		this.instanceKEY=guidInstance;
		this.attributes=new Attribute[0];
		this.categories=new Attribute[0];		
	}
	/**
	 * Returns the appBO.
	 * @return String
	 */
	public String getAppBO() {
		return appBO;
	}

	/**
	 * Returns the createdAt.
	 * @return long
	 */
	public long getCreatedAt() {
		return createdAt;
	}

	/**
	 * Returns the createdBy.
	 * @return String
	 */
	public String getCreatedBy() {
		return createdBy;
	}

	/**
	 * Returns the guidBO.
	 * @return String
	 */
	public String getGuidBO() {
		return guidBO;
	}

	/**
	 * Returns the idBO.
	 * @return String
	 */
	public String getIdBO() {
		return idBO;
	}

	/**
	 * Returns the instanceKEY.
	 * @return String
	 */
	public String getInstanceKEY() {
		return instanceKEY;
	}

	/**
	 * Returns the lastChangedAt.
	 * @return long
	 */
	public long getLastChangedAt() {
		return lastChangedAt;
	}

	/**
	 * Returns the lastChangedBy.
	 * @return String
	 */
	public String getLastChangedBy() {
		return lastChangedBy;
	}

	/**
	 * Returns the providerBO.
	 * @return String
	 */
	public String getProviderBO() {
		return providerBO;
	}

	/**
	 * Returns the relationType.
	 * @return int
	 */
	public int getRelationType() {
		return relationType;
	}

	/**
	 * Returns the roleBO.
	 * @return String
	 */
	public String getRoleBO() {
		return roleBO;
	}

	/**
	 * Sets the appBO.
	 * @param appBO The appBO to set
	 */
	public void setAppBO(String appBO) {
		this.appBO = appBO;
	}

	/**
	 * Sets the createdAt.
	 * @param createdAt The createdAt to set
	 */
	public void setCreatedAt(long createdAt) {
		this.createdAt = createdAt;
	}

	/**
	 * Sets the createdBy.
	 * @param createdBy The createdBy to set
	 */
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * Sets the guidBO.
	 * @param guidBO The guidBO to set
	 */
	public void setGuidBO(String guidBO) {
		this.guidBO = guidBO;
	}

	/**
	 * Sets the idBO.
	 * @param idBO The idBO to set
	 */
	public void setIdBO(String idBO) {
		this.idBO = idBO;
	}

	/**
	 * Sets the instanceKEY.
	 * @param instanceKEY The instanceKEY to set
	 */
	public void setInstanceKEY(String instanceKEY) {
		this.instanceKEY = instanceKEY;
	}

	/**
	 * Sets the lastChangedAt.
	 * @param lastChangedAt The lastChangedAt to set
	 */
	public void setLastChangedAt(long lastChangedAt) {
		this.lastChangedAt = lastChangedAt;
	}

	/**
	 * Sets the lastChangedBy.
	 * @param lastChangedBy The lastChangedBy to set
	 */
	public void setLastChangedBy(String lastChangedBy) {
		this.lastChangedBy = lastChangedBy;
	}

	/**
	 * Sets the providerBO.
	 * @param providerBO The providerBO to set
	 */
	public void setProviderBO(String providerBO) {
		this.providerBO = providerBO;
	}

	/**
	 * Sets the relationType.
	 * @param relationType The relationType to set
	 */
	public void setRelationType(int relationType) {
		this.relationType = relationType;
	}

	/**
	 * Sets the roleBO.
	 * @param roleBO The roleBO to set
	 */
	public void setRoleBO(String roleBO) {
		this.roleBO = roleBO;
	}

	/**
	 * Returns the attributes.
	 * @return Attribute[]
	 */
	public Attribute[] getAttributes() {
		return attributes;
	}

	/**
	 * Sets the attributes.
	 * @param attributes The attributes to set
	 */
	public void setAttributes(Attribute[] attributes) {
		this.attributes = attributes;
	}

	/**
	 * @return
	 */
	public Attribute[] getCategories() {
		return categories;
	}

	/**
	 * @param attributes
	 */
	public void setCategories(Attribute[] attributes) {
		categories = attributes;
	}

	/**
	 * @return
	 */
	public int getBackend() {
		return backend;
	}

	/**
	 * @param i
	 */
	public void setBackend(int i) {
		backend = i;
	}

	/**
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @return
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @param string
	 */
	public void setDescription(String string) {
		description = string;
	}

	/**
	 * @param string
	 */
	public void setDisplayName(String string) {
		displayName = string;
	}

}
