package com.sap.caf.km.datasvc.data;

/**
 * @author d040882
 *
 * Dataholder class for a business object. This class stores all necessary data of a
 * business object. It is used as a parameter in the webservice.
 * The business object is identically identified by the combination of appBO and idBO
 * separated by a dot.
 */
public class BO implements java.io.Serializable {
	private String guidBO;
	private String providerBO;
	private String appBO;
	private String idBO; 	
	private String serviceName;

	//this attribute is only valid (!=null) if this business object was
	//requested as part of a relation
	//in this case the attribute represents the name of the source role
	//for the relation
	private String roleBO=null;
	private int relationType=0;
	
	private String createdBy=null;
	private long createdAt=0;
	private long lastChangedAt=0;
	private String lastChangedBy=null;
	private String shortText=null;
	private String longText=null;		
	//indicates the type of object: 0 => business object 1 => shared dependent object 99 => dependent object
	private int type=0;
	
	private int backend=0;
	
	public BO() {
		
	}
	
	public BO(String guidBO, String provider, String application, String id, String service) {
		this.guidBO=guidBO;
		this.providerBO=provider;
		this.appBO=application;
		this.idBO=id;
		this.serviceName = service;
	}
	/**
	 * Returns the appBO.
	 * @return String
	 */
	public String getAppBO() {
		return appBO;
	}

	/**
	 * Returns the createdAt.
	 * @return long
	 */
	public long getCreatedAt() {
		return createdAt;
	}

	/**
	 * Returns the createdBy.
	 * @return String
	 */
	public String getCreatedBy() {
		return createdBy;
	}

	/**
	 * Returns the guidBO.
	 * @return String
	 */
	public String getGuidBO() {
		return guidBO;
	}

	/**
	 * Returns the idBO.
	 * @return String
	 */
	public String getIdBO() {
		return idBO;
	}

	/**
	 * Returns the lastChangedAt.
	 * @return long
	 */
	public long getLastChangedAt() {
		return lastChangedAt;
	}

	/**
	 * Returns the lastChangedBy.
	 * @return String
	 */
	public String getLastChangedBy() {
		return lastChangedBy;
	}

	/**
	 * Returns the longText.
	 * @return String
	 */
	public String getLongText() {
		return longText;
	}

	/**
	 * Returns the providerBO.
	 * @return String
	 */
	public String getProviderBO() {
		return providerBO;
	}

	/**
	 * Returns the relationType.
	 * @return int
	 */
	public int getRelationType() {
		return relationType;
	}

	/**
	 * Returns the roleBO.
	 * @return String
	 */
	public String getRoleBO() {
		return roleBO;
	}

	/**
	 * Returns the shortText.
	 * @return String
	 */
	public String getShortText() {
		return shortText;
	}

	/**
	 * Sets the appBO.
	 * @param appBO The appBO to set
	 */
	public void setAppBO(String appBO) {
		this.appBO = appBO;
	}

	/**
	 * Sets the createdAt.
	 * @param createdAt The createdAt to set
	 */
	public void setCreatedAt(long createdAt) {
		this.createdAt = createdAt;
	}

	/**
	 * Sets the createdBy.
	 * @param createdBy The createdBy to set
	 */
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	/**
	 * Sets the guidBO.
	 * @param guidBO The guidBO to set
	 */
	public void setGuidBO(String guidBO) {
		this.guidBO = guidBO;
	}

	/**
	 * Sets the idBO.
	 * @param idBO The idBO to set
	 */
	public void setIdBO(String idBO) {
		this.idBO = idBO;
	}

	/**
	 * Sets the lastChangedAt.
	 * @param lastChangedAt The lastChangedAt to set
	 */
	public void setLastChangedAt(long lastChangedAt) {
		this.lastChangedAt = lastChangedAt;
	}

	/**
	 * Sets the lastChangedBy.
	 * @param lastChangedBy The lastChangedBy to set
	 */
	public void setLastChangedBy(String lastChangedBy) {
		this.lastChangedBy = lastChangedBy;
	}

	/**
	 * Sets the longText.
	 * @param longText The longText to set
	 */
	public void setLongText(String longText) {
		this.longText = longText;
	}

	/**
	 * Sets the providerBO.
	 * @param providerBO The providerBO to set
	 */
	public void setProviderBO(String providerBO) {
		this.providerBO = providerBO;
	}

	/**
	 * Sets the relationType.
	 * @param relationType The relationType to set
	 */
	public void setRelationType(int relationType) {
		this.relationType = relationType;
	}

	/**
	 * Sets the roleBO.
	 * @param roleBO The roleBO to set
	 */
	public void setRoleBO(String roleBO) {
		this.roleBO = roleBO;
	}

	/**
	 * Sets the shortText.
	 * @param shortText The shortText to set
	 */
	public void setShortText(String shortText) {
		this.shortText = shortText;
	}

	/**
	 * @return
	 */
	public int getType() {
		return type;
	}

	/**
	 * @param i
	 */
	public void setType(int i) {
		type = i;
	}

	/**
	 * @return
	 */
	public int getBackend() {
		return backend;
	}

	/**
	 * @param i
	 */
	public void setBackend(int i) {
		backend = i;
	}
	
	/**
	 * Set short service name
	 * 
	 * @param service	Service short name
	 */
	public void setServiceName(String service) {
		this.serviceName = service;
	}

	/**
	 * Get short service name
	 * 
	 * @return
	 */
	public String getServiceName() {
		return serviceName;
	}
	
	/**
	 * Get full service name i.e. provider/application/serviceName
	 * 
	 * @return
	 */
	public String getFullServiceName() {
		return providerBO + "/" + appBO + "/" + serviceName;
	}
}
