/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_eclipse/src/com/sap/tc/jtools/jlint/jom/eclipse/JomRequestCreator.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.eclipse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

 
import com.sap.tc.jtools.jlint.eclipse.extension.IRequestCreator;
import com.sap.tc.jtools.jlint.eclipse.launch.EclipseRequest;
import com.sap.tc.jtools.jlint.eclipse.metadata.IMetaData;
import com.sap.tc.jtools.jtci.PerformUnit;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.TestObjectPosition;

/**
 * @author D037913
 */
public class JomRequestCreator implements IRequestCreator {

	protected List data = new ArrayList();
	protected List metaData = new ArrayList();
	protected Map testObjectID2JomRequest = new HashMap();

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.eclipse.extension.IRequestCreator#getRequests(java.lang.Object[])
	 */
	public EclipseRequest[] createRequests(Test[] tests) {
		if (data.size() == 0)
			return EclipseRequest.EMPTY_REQUEST_ARRAY;
		Collection sortedJavaEls = getSortedJavaElements(data);
		List requestList = new ArrayList(sortedJavaEls.size());
		for (Iterator iter = sortedJavaEls.iterator(); iter.hasNext();) {
			List jElList = (List) iter.next();
			requestList.add(
				new JomRequest(
					"JOM eclipse request",
					tests,
					(IJavaElement[]) jElList.toArray(new IJavaElement[0])));
		}
		JomRequest[] requests = (JomRequest[]) requestList.toArray(new JomRequest[0]);
		for (int i = 0; i < requests.length; i++) {
			PerformUnit[] performUnits = requests[i].getPerformUnits();
			for (int j = 0; j < performUnits.length; j++) {
				TestObject[] testObjects = performUnits[j].getSources();
				for (int k = 0; k < testObjects.length; k++) {
					testObjectID2JomRequest.put(testObjects[k].getID(),requests[i]);
				}
			}
		}
		return requests;
	}

	/**
	 * returns a Collection whose elements are lists of IJavaElements,
	 * sorted by IJavaProject the IJavaElements belong to
	 */
	protected Collection getSortedJavaElements(List selectedEls) {
		// sort by IJavaProject
		Map projectMap = new HashMap();
		for (Iterator iter = selectedEls.iterator(); iter.hasNext();) {
			Object selectedEl = iter.next();
			IJavaElement javaEl = null;
			IJavaProject proj = null;
			if (selectedEl instanceof IJavaElement) {
				javaEl = (IJavaElement) selectedEl;
			} else if (selectedEl instanceof IResource) {
				javaEl = JavaCore.create((IResource) selectedEl);
			}
			if (javaEl == null || !javaEl.exists())
				continue;
			proj = javaEl.getJavaProject();
			if (proj == null)
				continue;
			List elementList = (List) projectMap.get(proj);
			if (elementList == null) {
				elementList = new ArrayList();
				projectMap.put(proj, elementList);
			}
			elementList.add(javaEl);
		}
		return projectMap.values();
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.eclipse.extension.IRequestCreator#getResources()
	 */
	public IResource[] getResources() {
		List resources = new ArrayList();
		for (Iterator iter = data.iterator(); iter.hasNext();) {
			Object obj = iter.next();
			IResource res = null;
			if (obj instanceof IJavaElement) {
				res = ((IJavaElement) obj).getResource();
			} else if (obj instanceof IResource) {
				res = (IResource) obj;
			}
			if (res != null) {
				resources.add(res);
			}
		}
		return (IResource[]) resources.toArray(new IResource[0]);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.eclipse.extension.IRequestCreator#addData(java.lang.Object[])
	 */
	public void addData(Object[] data) {
		this.data.addAll(Arrays.asList(data));
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.eclipse.extension.IRequestCreator#addMetaData(com.sap.tc.jtools.jlint.eclipse.extension.IMetaData[])
	 */
	public void addMetaData(IMetaData[] metaData) {
		this.metaData.addAll(Arrays.asList(metaData));
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.eclipse.extension.IRequestCreator#reset()
	 */
	public void reset() {
		metaData.clear();
		data.clear();
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.jtools.jlint.eclipse.extension.IRequestCreator#getData(com.sap.tc.jtools.jtci.TestObjectPosition)
	 */
	public Object getData(String testObjectID,TestObjectPosition testObjectPosition) {
		JomRequest request =
			(JomRequest) testObjectID2JomRequest.get(testObjectID);
		if (request == null ) {
			return null;
		}
		return request.getData(testObjectID,testObjectPosition);
	}

}
