/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_eclipse/src/com/sap/tc/jtools/jlint/jom/eclipse/JomMarkerManager.java#3 $
 */

package com.sap.tc.jtools.jlint.jom.eclipse;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

import com.sap.tc.jtools.jlint.eclipse.JlinPlugin;
import com.sap.tc.jtools.jlint.eclipse.extension.IMarkerManager;
import com.sap.tc.jtools.jlint.eclipse.extension.IMarkerPosition;
import com.sap.tc.jtools.jlint.eclipse.launch.MarkerPosition;
import com.sap.tc.jtools.jtci.FilePosition;
import com.sap.tc.jtools.jtci.TestObjectPosition;

/**
 * @author D037913
 */
public class JomMarkerManager implements IMarkerManager {

  private IJavaProject lastProject;

  /* (non-Javadoc)
   * @see com.sap.tc.jtools.jlint.eclipse.extension.IMarkerManager#createJLinMarker(com.sap.tc.jtools.jtci.TestObjectPosition, org.eclipse.core.resources.IProject)
   */
  public IMarkerPosition getMarkerPosition(
    TestObjectPosition position,
    IProject correspondingProject) {
    if (position == null) {
      return new MarkerPosition(correspondingProject, -1, -1);
    } else if (!(position instanceof FilePosition)) {
      return null;
    }
    FilePosition fp = (FilePosition) position;
    int line = fp.getLine();
    int col = fp.getColumn();
    IJavaProject jProj = JavaCore.create(correspondingProject);
    IJavaElement el = null;
    IResource res = null;
    try {
      el = jProj.findElement(new Path(fp.getFile()));
      if (el != null) {
        res = el.getCorrespondingResource();
      }
    } catch (JavaModelException jme) {
      JlinPlugin.log(jme);
    }
    if (res == null)
      res = findResource(fp);
    if (res == null)
      return null;
    return new MarkerPosition(res, line, col);
  }

  private IResource findResource(FilePosition fp) {
    IResource res = null;
    IPath pathToFind = new Path(fp.getFile());
    IJavaElement jEl = null;
    try {
      if (lastProject != null) {
        jEl = lastProject.findElement(pathToFind);
        if (jEl != null)
          return jEl.getCorrespondingResource();
      }
    } catch (JavaModelException jme) { //$JL-EXC$
      // try all projects
    }
    IProject[] allProjects =
      ResourcesPlugin.getWorkspace().getRoot().getProjects();
    IJavaProject jProj;
    for (int i = 0; i < allProjects.length; i++) {
      jProj = JavaCore.create(allProjects[i]);
      try {
        jEl = jProj.findElement(new Path(fp.getFile()));
        if (jEl == null)
          continue;
        res = jEl.getCorrespondingResource();
        if (res == null) {
          continue;
        } else {
          lastProject = jProj;
          return res;
        }
      } catch (JavaModelException jme) {
        JlinPlugin.log(jme);
      }
    }
    return res;
  }

}
