/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.events;

import com.sapportals.wcm.util.enum.AbstractEnum;

/**
 * Enumeration of event sender modes. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @see IEventSender
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/events/SenderMode.java#6
 *      $
 * @review-reader Paul Goetz
 * @review-date 10.01.2002
 */
public final class SenderMode extends AbstractEnum {

  public final static SenderMode OFF = new SenderMode(1);
  public final static SenderMode SENDING = new SenderMode(2);
  public final static SenderMode SUSPEND = new SenderMode(3);
  public final static SenderMode HOLD = new SenderMode(4);

  private SenderMode(int code) {
    super(code);
  }

}
