/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: ITransactionalEventReceiver.java,v 1.1 2005/01/21 11:49:20 mbo Exp $
 */

package com.sapportals.wcm.util.events;

import com.sapportals.wcm.IFrameworkTransaction;

/**
 * This interface defines a transactional event receiver. Receivers must be registered at a
 * {@link ITransactionalEventBroker}. <p>
 *
 * Copyright (c) SAP AG 2004
 * @author martin.boettcher@greenbytes.de
 */
public interface ITransactionalEventReceiver extends IEventReceiver {

  /**
   * This method will be called by the broker with an event.
   *
   * @param ft the framework transaction to be used to access the persistence
   * @param event the event sent by the sender (maybe mapped, see {@link
   *      IEventMapper}).
   * @return false if the transaction shall be rollbacked
   */
  public boolean received(IFrameworkTransaction ft, IEvent event);

}
