/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: ITransactionalEventBroker.java,v 1.1 2005/01/21 11:49:20 mbo Exp $
 */

package com.sapportals.wcm.util.events;

import com.sapportals.wcm.IFrameworkTransaction;
import com.sapportals.wcm.WcmException;

/**
 * The transactional event broker is a mediator between event senders ({@link IEventSender})
 * and receivers ({@link ITransactionalEventReceiver}). All senders and receivers must
 * register themselfs with a broker. All receivers will receive events from all
 * senders but it is possible to register for different event "templates" (event
 * class and type). Usually a sender will instanciate its own broker and
 * register itself.
 * <p>
 * Copyright (c) SAP AG 2004
 * @author martin.boettcher@greenbytes.de
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/events/ITransactionalEventBroker.java#8
 *      $
 */
public interface ITransactionalEventBroker extends IEventBroker {


  /**
   * Sends the specified event to all receivers that have registered for this
   * kind of event.
   *
   * @return true if the sending to the transactional event receivers was completely performed (=no error), false otherwise 
   * @param ft the IFrameworkTransaction the Connection to be used to access any persistenz
   * @param event The event so send.
   * @param sender The event sended instance (the caller).
   * @exception WcmException If the event sender is not registered.
   */
  public boolean send(IFrameworkTransaction ft, IEvent event, IEventSender sender)
    throws WcmException;

}
