/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.events;

/**
 * This interface defines an event receiver. Receivers must be registered at a
 * {@link IEventBroker}. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/events/IEventReceiver.java#6
 *      $
 * @review-reader Paul Goetz
 * @review-date 10.01.2002
 */
public interface IEventReceiver {

  /**
   * This method will be called by the broker with an event.
   *
   * @param event the event sent by the sender (maybe mapped, see {@link
   *      IEventMapper}).
   */
  public void received(IEvent event);

}
