/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.events;

import java.util.Locale;

/**
 * An event mapper maps events to other events. This mapping takes place inside
 * the event broker for receivers that have registered an event mapper. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/events/IEventMapper.java#4
 *      $
 * @review-reader Paul Goetz
 * @review-date 10.01.2002
 */
public interface IEventMapper {

  /**
   * Get the mapper's unique system id.
   *
   * @return a <code>String</code> with the mapper's system id.
   */
  public String getID();


  /**
   * Get the mapper's displayable name.
   *
   * @return a <code>String</code> with the mapper's displayable name.
   */
  public String getDescription();


  /**
   * Get the mapper's displayable name for a specific locale.
   *
   * @param locale a <code>Locale</code> defining the language to get the name
   *      for.
   * @return a <code>String</code> with the mapper's displayable name in the
   *      given locale.
   */
  public String getDescription(Locale locale);


  /**
   * Map an <code>IEvent</code> to another <code>IEvent</code> .<br>
   * <i>Note</i> : It's a good idea, to pass the original (unmapped) event as
   * the mapped event's parameter.
   *
   * @param event the <code>IEvent</code> to map.
   * @return the mapped <code>IEvent</code> corresponding to the given event or
   *      <code>null</code> , if the event is to be ignored (not mapped).
   */
  public IEvent map(IEvent event);


  /**
   * Get a list of available mapped events for a given broker.
   *
   * @param broker the <code>IEventBroker</code> to get the supported events
   *      for.
   * @return the <code>IEventList</code> with all available mapped events.
   */
  public IEventList getEvents(IEventBroker broker);

}
