/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.events;

import com.sapportals.wcm.WcmException;

/**
 * This interface defines a mutable list of {@link IEvent} instances. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/events/IEventList.java#6
 *      $
 * @review-reader Paul Goetz
 * @review-date 10.01.2002
 */
public interface IEventList {

  public int size();

  public boolean isEmpty();

  public boolean add(IEvent event);

  public IEvent get(int index);

  public IEvent set(int index, IEvent event);

  public void add(int index, IEvent event);

  public boolean addAll(IEventList list);

  public void addLast(IEvent event);

  public void addFirst(IEvent event);

  public IEvent remove(int index);

  public void clear();

  public IEventListIterator listIterator();

  public IEventListIterator listIterator(int index);
}
