/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.events;

import java.util.Locale;

/**
 * This interface defines an event with a type and an arbitrary parameter. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/events/IEvent.java#7
 *      $
 * @review-reader Paul Goetz
 * @review-date 10.01.2002
 */
public interface IEvent {

  /**
   * Returns the event's type
   *
   * @return the event's type
   */
  public int getType();

  /**
   * Returns the event's parameter
   *
   * @return the event's parameter
   */
  public Object getParameter();

  /**
   * Compares this event with another event for equality or some kind of
   * "similarity". Normally an event equals another if it is of the same
   * instance and type. There might be implementations that want to match one
   * event type with many others.
   *
   * @param template The other event to compare with.
   * @return True, if the specified event template is equal to this event,
   *      according to the implemented matching rules.
   */
  public boolean isLike(IEvent template);

  public String getDescription();

  public String getDescription(Locale locale);
}
