/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.events;

import java.util.ListIterator;

/**
 * An event list iterator implementation. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/util/api/com/sapportals/wcm/util/events/EventListIterator.java#8
 *      $
 * @review-reader Paul Goetz
 * @review-date 10.01.2002
 */
public class EventListIterator implements IEventListIterator {

  private ListIterator m_it = null;

  public EventListIterator(ListIterator it) {
    m_it = it;
  }

  public boolean hasNext() {
    return m_it.hasNext();
  }

  public IEvent next() {
    return (IEvent)m_it.next();
  }
}
