/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.events;

import com.sapportals.wcm.WcmException;

import java.util.*;

/**
 * An event list implementation. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/events/EventList.java#6
 *      $
 * @review-reader Paul Goetz
 * @review-date 10.01.2002
 */
public class EventList implements IEventList {

  private LinkedList list = null;

  public EventList() {
    this.list = new LinkedList();
  }

  public EventList(EventList list) {
    this.list = new LinkedList(list.list);
  }


  public int size() {
    return this.list.size();
  }

  public boolean isEmpty() {
    return this.list.isEmpty();
  }

  public boolean add(IEvent event) {
    return this.list.add(event);
  }

  public boolean addAll(IEventList list) {
    return this.list.addAll(((EventList)list).list);
  }


  public IEvent get(int index) {
    return (IEvent)this.list.get(index);
  }

  public IEvent set(int index, IEvent event) {
    return (IEvent)this.list.set(index, event);
  }

  public void add(int index, IEvent event) {
    this.list.add(index, event);
  }

  public void addLast(IEvent event) {
    this.list.addLast(event);
  }

  public void addFirst(IEvent event) {
    this.list.addFirst(event);
  }

  public IEvent remove(int index) {
    return (IEvent)this.list.remove(index);
  }

  public void clear() {
    this.list.clear();
  }

  public IEventListIterator listIterator() {
    return new EventListIterator(this.list.listIterator());
  }

  public IEventListIterator listIterator(int index) {
    return new EventListIterator(this.list.listIterator(index));
  }

  public String toString() {
    return this.list.toString();
  }
}
