/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.events;

import com.sapportals.wcm.WcmException;

import java.util.Locale;
import java.util.Properties;

/**
 * A base class to derive event mapper implementations. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/events/AbstractEventMapper.java#4
 *      $
 * @see IEventMapper
 * @review-reader Paul Goetz
 * @review-date 10.01.2002
 */
public abstract class AbstractEventMapper
   implements IEventMapper {

  // ---------
  // Constants ----------------------------------------------------------------
  // ---------

  protected final static String CONFIG_NAME_TAG = "name";

  // ------------------
  // Instance Variables -------------------------------------------------------
  // ------------------

  /**
   * The system id for this mapper.
   */
  protected String m_ID = null;

  /**
   * The properties for this mapper.
   */
  protected Properties m_Properties = null;


  // ------------
  // Constructors -------------------------------------------------------------
  // ------------

  /**
   * Create a mapper with a specific id from the given properties.
   *
   * @param id TBD: Description of the incoming method parameter
   * @param properties TBD: Description of the incoming method parameter
   * @exception WcmException Exception raised in failure situation
   */
  protected AbstractEventMapper(String id,
    Properties properties)
    throws WcmException {

    m_ID = id;
    m_Properties = properties;

  }


  // ------------
  // IEventMapper -------------------------------------------------------------
  // ------------

  public String getID() {

    return m_ID;
  }


  public String getDescription() {

    return m_Properties.getProperty(CONFIG_NAME_TAG, m_ID);
  }


  public String getDescription(Locale locale) {

    return getDescription();
  }


  public abstract IEvent map(IEvent event);


  public IEventList getEvents(IEventBroker broker) {

    IEventList events = new EventList();

    if (broker == null) {
      return events;
    }

    IEventList brokerEvents = broker.getEvents();
    IEventListIterator brokerEventIterator = brokerEvents.listIterator();
    while (brokerEventIterator.hasNext()) {
      IEvent mappedEvent = map(brokerEventIterator.next());
      if (mappedEvent != null) {
        events.add(mappedEvent);
      }
    }

    return events;
  }

}
