/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/repository/util/ResourceTypeUtil.java#1 $
 */

package com.sapportals.wcm.repository.util;

import com.sapportals.wcm.repository.*;

/**
 * @todo: Description of the class.
 */
public class ResourceTypeUtil {

  /**
   * Checks if a resource is of a given resourceType.
   *
   * @param resource Resource to check
   * @param resourceType ResourceType to search for
   * @return True if the resourceType property contains #resourceType
   * @exception ResourceException Exception raised in failure situation
   */
  public static boolean isA(IResource resource, String resourceType)
    throws ResourceException {
    if (null == resource) {
      return false;
    }
    if (null == resourceType || resourceType.length() == 0) {
      return false;
    }

    IProperty prop = resource.getProperty(PropertyName.createResourceType());

    if (null == prop) {
      return false;
    }

    if (true == prop.isMultivalued()) {
      return (prop.getValues().contains(resourceType));
    }
    else {
      return (prop.getValueAsString().equals(resourceType));
    }
  }
}

