/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.so;

import com.sapportals.wcm.crt.CrtClassLoaderRegistry;

import com.sapportals.wcm.repository.*;

/**
 * @todo: Description of the class.
 */
public class ObjectFactoryRegistry {

  /**
   * The instance of TypeCastRegistry
   */
  private static IObjectFactoryRegistry g_coreInstance = null;

  /**
   * Contructs a new ResourceFactory
   */
  private ObjectFactoryRegistry() { }

	public static synchronized void reset() {
    g_coreInstance = null;    
  }
  
	
  /**
   * Return a reference to the singleton factory instance !!! ONLY FOR INTERNAL
   * USE !!!
   *
   * @return The factory instance
   * @exception ResourceException
   */
  public static synchronized IObjectFactoryRegistry getInstance()
    throws ResourceException {
    if (g_coreInstance == null) {
      try {
        Class coreClass = CrtClassLoaderRegistry.forName("com.sapportals.wcm.repository.so.ObjectFactoryRegistryCore");
        g_coreInstance = (IObjectFactoryRegistry)coreClass.newInstance();
      }
      catch (Exception e) {
        throw new ResourceException(e);
      }
    }
    return g_coreInstance;
  }
}
