/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.so;

import java.util.Collection;

import com.sapportals.wcm.repository.IVersionControlledResource;

/**
 * The ITypeCast interface provides means to access additional interfaces
 * that an object may support. The full set of available interfaces generally 
 * generally is only known at runtime and may change with the state of a resource.
 * <p>
 * Copyright (c) SAP AG 2001-2004
 * @author frank.renkes@sap.com
 * @author julian.reschke@greenbytes.de
 * @see IVersionControlledResource for usage example
 */
public interface ITypeCast {

  /**
   * Checks whether the specified class can be obtained.
   * @param classRef requested class
   * @return <code>true</code> if the specified class can be obtained.
   */
  public boolean isA(Class classRef);

  // TODO: document why as() would ever throw an exception. The original contract for isA()/as() was consistent in that both never throw exceptions.
  /**
   * Tries to obtain an object of the specified class.
   * @param classRef requested class
   * @return an object implementing the specified class or <code>null</code> when not available
   */
  public Object as(Class classRef) throws Exception;

  // TODO: add documentation. Note that the full list of supported types can not be computed so it is unclear what this method actually returns
  Collection listTypes();
}
