/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.so;
import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IResource;

import java.util.ListIterator;

/**
 * @todo: Description of the interface.
 */
public interface IObjectFactoryRegistry {
  /**
   * Registration of a new provider. Everytime an application will ask to get
   * the possible types of a resource object the RegistryCore will ask all
   * provider to get a list of possible type casts.
   *
   * @param factory TBD: Description of the incoming method parameter
   */
  public void registerObjectFactory(IObjectFactory factory);

  /**
   * Get the DefaultProvider attribute of the ITypeCastRegistry object.
   *
   * @return The DefaultProvider value
   */
  public IMutableObjectFactory getDefaultObjectFactory();

  /**
   * @return TBD: Description of the outgoing return value
   * @todo: Description of the Method.
   * @todo: Description of the outgoing return value
   */
  public ListIterator factoryListIterator();

  /**
   * Get the A attribute of the ITypeCastRegistry object.
   *
   * @param cl
   * @param res
   * @return The A value
   * @exception WcmException Exception raised in failure situation
   * @todo: Description of the incoming method parameter
   * @todo: Description of the incoming method parameter
   */
  public boolean isA(Class cl, IResource res)
    throws WcmException;

  /**
   * @param cl
   * @param res
   * @return
   * @exception WcmException Exception raised in failure situation
   * @todo: Description of the Method.
   * @todo: Description of the incoming method parameter
   * @todo: Description of the incoming method parameter
   * @todo: Description of the outgoing return value
   */
  public Object as(Class cl, IResource res)
    throws WcmException;
}
