/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.so;

import com.sapportals.wcm.crt.CrtClassLoaderRegistry;

import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.repository.so.ITypeCast;
import java.lang.reflect.Constructor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/**
 * @todo: Description of the class.
 */
public class DefaultObjectFactory implements IMutableObjectFactory {

  protected Map mappings = new HashMap();// resourceType -> Vector(Mapping)

  protected Map rt_cr = new HashMap();// resourceType -> Vector(classRefImpl)
  protected Map rt_ir = new HashMap();// resourceType -> Vector(interfaceRefImpl)
  protected Map ir_rt = new HashMap();// classRef -> Vector(resourceTypes)

  /**
   * TBD: Description of the class.
   */
  private class Mapping {
    public String resourceType = null;
    public Class classRefImpl = null;
    public Vector interfaceRefs = new Vector();

    public Mapping(String rt, Class impl) {
      this.resourceType = rt;
      this.classRefImpl = impl;
    }
  }

  private synchronized Vector getSetVectorFromMap(Map map, Object key) {
    Vector vec = (Vector)map.get(key);

    if (null != vec) {
      return vec;
    }

    vec = new Vector();
    map.put(key, vec);
    return vec;
  }

  private Mapping getMapping(String resourceType, Class interfaceRef) {
    Vector mappings = (Vector)this.mappings.get(resourceType);

    if (null != mappings) {
      Iterator iter = mappings.iterator();
      while (iter.hasNext()) {
        Mapping mapping = (Mapping)iter.next();
        if (mapping.interfaceRefs.contains(interfaceRef)) {
          return mapping;
        }
      }
    }
    return null;
  }

  /**
   * Get the A attribute of the DefaultTypeCastProvider object.
   *
   * @param resource
   * @param interfaceRef TBD: Description of the incoming method parameter
   * @return The A value
   * @exception ResourceException Exception raised in failure situation
   * @todo: Description of the incoming method parameter
   * @todo: Description of the incoming method parameter
   */
  public boolean isA(Class interfaceRef, IResource resource)
    throws ResourceException {
    IProperty prop = resource.getProperty(PropertyName.createResourceType());

    if (null != prop) {
      if (prop.isMultivalued()) {
        List values = prop.getValues();
        Iterator vIter = values.iterator();

        while (vIter.hasNext()) {
          String value = (String)vIter.next();
          if (this.isA(interfaceRef, prop.getStringValue()) == true) {
            return true;
          }
        }
      }
      else {
        return this.isA(interfaceRef, prop.getStringValue());
      }
    }
    return false;
  }

  private Object as(Class interfaceRef, String resourceType, IResource resource)
    throws ResourceException {
    Object proxy = null;
    Mapping mapping = this.getMapping(resourceType, interfaceRef);

    if (null == mapping) {
      throw new ResourceException("can't create semantic object no registered mapping found");
    }

    try {
      if (mapping.interfaceRefs.contains(interfaceRef)) {

        Class classRefImpl = (Class)mapping.classRefImpl;

        if (com.sapportals.wcm.crt.CrtClassLoaderRegistry.forName("com.sapportals.wcm.repository.so.ITypeCast").isAssignableFrom(classRefImpl)) {

          if (resource.isCollection()) {
            Class[] constrParams = new Class[]{ICollection.class};
            Object[] params = new Object[]{resource};

            try {
              Constructor constr = classRefImpl.getConstructor(constrParams);
              proxy = constr.newInstance(params);
            }
            catch (Exception ex) {
              // no collection constructor, try to call contructor with resource
              proxy = null;
            }
          }

          if (null == proxy) {
            Class[] constrParams = new Class[]{IResource.class};
            Object[] params = new Object[]{resource};

            Constructor constr = classRefImpl.getConstructor(constrParams);

            try {
              proxy = constr.newInstance(params);
            }
            catch (Exception ex) {
              throw new ResourceException(ex);
            }
          }

          return proxy;
        }
      }
    }
    catch (Exception ex) {
      throw new ResourceException("can't create semantic object - no resource type property found", ex);
    }

    return null;
  }

  /**
   * @param classRef
   * @param resource
   * @return TBD: Description of the outgoing return value
   * @exception ResourceException Exception raised in failure situation
   * @todo: Description of the Method.
   * @todo: Description of the incoming method parameter
   * @todo: Description of the incoming method parameter
   * @todo: Description of the outgoing return value
   */
  public Object as(Class classRef, IResource resource)
    throws ResourceException {
    if (false == this.isA(classRef, resource)) {
      return null;
    }

    try {
      IProperty prop = resource.getProperty(PropertyName.createResourceType());

      if (null != prop) {
        if (prop.isMultivalued()) {
          List values = prop.getValues();
          Iterator vIter = values.iterator();

          while (vIter.hasNext()) {
            String value = (String)vIter.next();
            Object proxy = this.as(classRef, value, resource);

            if (null != proxy) {
              return proxy;
            }
          }
        }
        else {
          String value = prop.getValueAsString();

          return this.as(classRef, value, resource);
        }
      }
    }
    catch (Exception ex) {
      throw new ResourceException("can't create semantic object - no resource type property found", ex);
    }

    return null;
  }

  /**
   * @param resource
   * @return TBD: Description of the outgoing return value
   * @todo: Description of the Method.
   * @todo: Description of the incoming method parameter
   * @todo: Description of the outgoing return value
   */
  public Collection listTypes(IResource resource) {
    // Write your code here
    return null;
  }

  /**
   * @param resourceType
   * @param classRef
   * @exception SoException Exception raised in failure situation
   * @todo: Description of the outgoing return value
   * @todo: Description of the Method.
   * @todo: Description of the incoming method parameter
   * @todo: Description of the incoming method parameter
   */
  public void registerClass(String resourceType, Class classRef)
    throws SoException {
    Vector interfaces = new Vector();
    // add reverse mapping from classrefs to resourcetype
    Class[] classes = classRef.getClasses();

    for (int i = 0; i < classes.length; i++) {
      interfaces.add(classes[i]);
    }

    this.registerClass(resourceType, classRef, interfaces);
    return;
  }

  /**
   * @param resourceType
   * @param classRef
   * @param interfaces TBD: Description of the incoming method parameter
   * @exception SoException Exception raised in failure situation
   * @todo: Description of the outgoing return value
   * @todo: Description of the Method.
   * @todo: Description of the incoming method parameter
   * @todo: Description of the incoming method parameter
   */
  public void registerClass(String resourceType, Class classRef, Vector interfaces)
    throws SoException {
    // classRef mus be a real class (not an interface or an abstract class
    if (classRef.isInterface() == true) {
      throw new SoException("registered class is not an interface");
    }

    Mapping mapping = new Mapping(resourceType, classRef);
    mapping.interfaceRefs = (Vector)interfaces.clone();

    this.getSetVectorFromMap(mappings, resourceType).add(mapping);

    // build reverse mapping from interfaces to resource type

    Iterator iIter = interfaces.iterator();
    while (iIter.hasNext()) {
      Class interfaceRef = (Class)iIter.next();

      this.getSetVectorFromMap(ir_rt, interfaceRef).add(resourceType);
      this.getSetVectorFromMap(rt_ir, resourceType).add(interfaceRef);
    }

    // build reverse mapping from resourceType to classref
    this.getSetVectorFromMap(rt_cr, resourceType).add(classRef);

    return;
  }


  /**
   * Checks if a mapping exists from resourceType to classRef.
   *
   * @param resourceType
   * @param interfaceRef TBD: Description of the incoming method parameter
   * @return The A value
   * @todo: Description of the incoming method parameter
   * @todo: Description of the incoming method parameter
   */
  protected boolean isA(Class interfaceRef, String resourceType) {
    Vector irefs = (Vector)this.rt_ir.get(resourceType);

    if (null != irefs) {
      if (irefs.contains(interfaceRef)) {
        return true;
      }
    }

    return false;
  }
}
