/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.service;

import com.sapportals.wcm.repository.ResourceException;
import java.util.Collections;
import java.util.List;

/**
 * Indicates that a repository service will not be available at one or more
 * repositories. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Revision: 1.3 $
 */
public class ServiceNotAvailableException extends ResourceException {

  private final List mgrIdList;
  private final List messages;

  /**
   * Constructs a new exception
   *
   * @param mgrIdList a list of repository manager identifiers (String).
   * @param messages The reasons why the repositries will not be available - one
   *      per repository ID contained in the list of the first parameter.
   */
  public ServiceNotAvailableException(List mgrIdList, List messages) {
    super(false);
    this.mgrIdList = Collections.unmodifiableList(mgrIdList);
    this.messages = Collections.unmodifiableList(messages);
  }

  /**
   * Constructs a new exception
   *
   * @param msg The reason why the repository service will not be avialable
   */
  public ServiceNotAvailableException(String msg) {
    super(msg, false);
    this.mgrIdList = null;
    this.messages = null;
  }

  /**
   * Returns the identifiers of repositories for which the service will not be
   * available.
   *
   * @return repositoryManagerIDs
   */
  public List getRepositoryManagerIDs() {
    return this.mgrIdList;
  }

  /**
   * Returns the list of error messages - one for each repository.
   *
   * @return messages
   */
  public List getMessages() {
    return this.messages;
  }
}
