/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.service;

import java.util.Properties;
import com.sapportals.wcm.repository.IResourceContext;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.URI;

/**
 * Indicates an error during a {@link IRepositoryService#acceptServletCall(Properties, IResourceContext)}
 * call. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Revision: 1.3 $
 */
public class ServiceCallException extends ResourceException {

  private String localizedErrormessage = null;

  /**
   * Constructs a new exception
   *
   * @param localizedErrormessage The message for display
   */
  public ServiceCallException(String localizedErrormessage) {
    super(false);
    this.localizedErrormessage = localizedErrormessage;
  }

  /**
   * Constructs a new exception
   *
   * @param resourceID The URI of the resource that caused the exception
   *      (optional)
   * @deprecated as of NW04.
   */
  public ServiceCallException(URI resourceID) {
    super(resourceID, false);
  }

  /**
   * Constructs a new exception
   *
   * @param resourceID The URI of the resource that caused the exception
   *      (optional)
   */
  public ServiceCallException(RID resourceID) {
    super(resourceID, false);
  }

  /**
   * Constructs a new exception
   *
   * @param localizedErrormessage The message for display
   * @param resourceID The URI of the resource that caused the exception
   *      (optional)
   * @deprecated as of NW04.
   */
  public ServiceCallException(String localizedErrormessage, URI resourceID) {
    super(resourceID, false);
    this.localizedErrormessage = localizedErrormessage;
  }

  /**
   * Constructs a new exception
   *
   * @param localizedErrormessage The message for display
   * @param resourceID The URI of the resource that caused the exception
   *      (optional)
   */
  public ServiceCallException(String localizedErrormessage, RID resourceID) {
    super(resourceID, false);
    this.localizedErrormessage = localizedErrormessage;
  }

  /**
   * Returns a message for display
   *
   * @return a message for display
   */
  public String getErrorMessage() {
    return this.localizedErrormessage;
  }
}
