/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.service;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.IResourceContext;
import com.sapportals.wcm.repository.ResourceException;

import java.util.Collection;

import java.util.Locale;
import java.util.Properties;

/**
 * A repository service implements additional functionalities for repositories,
 * e.g. subscription and indexing/searching. In general, a repository service is
 * independent of a specific repository implementation. Services can subscribe
 * for events of repository managers, to be informed about state changes of
 * resources.
 */
public interface IRepositoryService {

  /**
   * Get the service's service type, as defined in IWcmConfig.
   *
   * @return The service type constant for this service.
   * @deprecated As of EP 5.0 SP5, The "service type" is the name of the
   *      configurable class.
   */
  public String getServiceType();


  /**
   * Returns a service identifier, unique for this instance.
   *
   * @return a service identifier, unique for this instance.
   */
  public String getID();


  /**
   * Returns a description for this service.
   *
   * @return a description for this service.
   */
  public String getDescription();


  /**
   * Returns a description for this service.
   *
   * @param locale TBD: Description of the incoming method parameter
   * @return a description for this service.
   */
  public String getDescription(Locale locale);

  /**
   * This method is called by the <code>eServiceServlet</code> to perform some
   * action.
   *
   * @param properties TBD: Description of the incoming method parameter
   * @param context TBD: Description of the incoming method parameter
   * @return The message to show on the servlet
   * @exception ServiceCallException Exception raised in failure situation
   * @exception ResourceException Exception raised in failure situation
   */
  public String acceptServletCall(Properties properties, IResourceContext context)
    throws ServiceCallException, ResourceException;

}
