/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/repository/security/IResourceAclRaw.java#1 $
 */

package com.sapportals.wcm.repository.security;


import java.util.*;

import com.sapportals.portal.security.usermanagement.*;
import com.sapportals.wcm.util.acl.*;
import com.sapportals.wcm.repository.*;


/**
 * A <code>IResourceAclRaw</code> is a <code>IResourceAcl</code> which is
 * also able to provide information about owners and entries for principals,
 * which have already been deleted. <br>
 * 
 */
public interface IResourceAclRaw
extends IResourceAcl {

  /**
   * Get a list of ACL-owners.
   * But unlike <code>IResourceAcl.getOwners()</code>, a list retrieved
   * with <code>getOwnersRaw()</code> might also contain
   * <code>com.sapportals.wcm.util.acl.IUMPrincipalRaw</code>s for
   * principals, which do no longer exist.
   * @return a list of the owners of the ACL
   * @exception AclPersistenceException indicates an ACL persistence
   *          error
   */
  public IUMPrincipalList getOwnersRaw()
                                throws AclPersistenceException;


  /**
   * Get a list of ACEs.
   * But unlike <code>IResourceAcl.getEntries()</code>, a list retrieved
   * with <code>getEntriesRaw()</code> might also contain
   * <code>IResourceAclEntryRaw</code> entries for ACEs of principals,
   * which do no longer exist.
   * @return a list of the ACEs of the ACL
   * @exception AclPersistenceException indicates an ACL persistence
   *          error
   */
  public IResourceAclEntryList getEntriesRaw()
                                      throws AclPersistenceException;


}
