/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf/60NW_SP_COR/src/_framework/java/api/com/sapportals/wcm/repository/security/IResourceAclManagerRaw.java#1 $
 */

package com.sapportals.wcm.repository.security;


import java.util.*;

import com.sapportals.portal.security.usermanagement.*;
import com.sapportals.wcm.util.acl.*;
import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.repository.manager.*;


/**
 * The <code>IResourceAclManagerRaw</code> provides methods to access
 * the even raw ACLs. <br>
 * Raw ACLs (<code>IResourecAclRaw</code>) are ACLs, which contain
 * principals no longer available throug the user management. That are
 * principals, which have already been deleted.
 */
public interface IResourceAclManagerRaw
extends IResourceAclManager {

  /**
   * Get the - potentially raw - ACL of a specific resource.
   * @param resource the <code>IResource</code> to get the ACL (maybe raw)
   *        for
   * @return the ACL of the resource or <code>null</code> if no ACL is
   *        assigned yet. This ACL may be a <code>IResourceAclRaw</code>,
   *        if at least one of the ACL's owners or one of the ACE's principals
   *        implements the <code>IUMPrincipalRaw</code> interface. 
   * @exception AclPersistenceException indicates a storage problem
   * @exception ResourceException the resource's RID could not be determined
   */
  public IResourceAcl getAclRaw(IResource resource)
                         throws AclPersistenceException,
                                ResourceException;


}
