/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.security;

import com.sapportals.portal.security.usermanagement.*;
import com.sapportals.wcm.repository.*;

import com.sapportals.wcm.util.acl.*;

import java.util.*;

/**
 * An IResourceAclEntry is a wrapper for an IAclEntry which passes the user in
 * the resource context of the belonging IResourceAcl as 'callers' to IAclEntry
 * methods Abbreviations ACL Access Control List ACE Access Control List Entry
 */
public interface IResourceAclEntry {
  /**
   * get the permission of the ACE
   *
   * @return the permission
   * @exception AclPersistenceException a problem with the storage where the
   *      ACLs are persisted occurred
   */
  public IAclPermission getPermission()
    throws AclPersistenceException;

  /**
   * check whether some permission is covered by the permission of the ACE
   *
   * @param permission the permission
   * @return true iff all members of the permission are contained in the
   *      permission of the ACE
   * @exception AclPersistenceException a problem with the storage where the
   *      ACLs are persisted occurred
   * @exception InvalidClassException the permission was created by a foreign
   *      resource IResourceAclManager
   */
  public boolean checkPermission(IAclPermission permission)
    throws AclPersistenceException, InvalidClassException;

  /**
   * check whether the ACE denies its permission
   *
   * @return true iff the ACE denies its permission
   * @exception AclPersistenceException a problem with the storage where the
   *      ACLs are persisted occurred
   */
  public boolean isNegative()
    throws AclPersistenceException;

  /**
   * get the principal of the ACE
   *
   * @return the principal of the ACE
   * @exception AclPersistenceException a problem with the storage where the
   *      ACLs are persisted occurred
   */
  public IUMPrincipal getPrincipal()
    throws AclPersistenceException;

  /**
   * check wether the ACE is read only
   *
   * @return true iff the ACE is read only
   * @exception AclPersistenceException a problem with the storage where the
   *      ACLs are persisted occurred
   */
  public boolean isReadOnly()
    throws AclPersistenceException;

  /**
   * get the sort index of the ACE - the sequence of the ACEs in the ACL is
   * controlled by the sort indices - the sequence is only relevant if the
   * IResourceAclManager supports negative ACEs (check with the
   * areNegativeAclEntriesSupported() method)
   *
   * @return the sort index
   * @exception AclPersistenceException a problem with the storage where the
   *      ACLs are persisted occurred
   */
  public int getSortIndex()
    throws AclPersistenceException;

  /**
   * set the sort index of the ACE
   *
   * @param sortIndex sortIndex to be set
   * @exception AclPersistenceException a problem with the storage where the
   *      ACLs are persisted occurred
   * @exception NotAuthorizedException the user in the resource context of the
   *      belonging ACL is not an owner of the ACL
   */
  public void setSortIndex(int sortIndex)
    throws AclPersistenceException, NotAuthorizedException;// caller may be null in case the ace is not yet part of an acl
}
