/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.search;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.repository.enum.*;
import com.sapportals.wcm.repository.manager.IRepositoryManager;

/**
 * Builds generic query expressions. <p>
 *
 * Copyright (c) SAP AG 2002
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Revision: 1.1 $
 */
public interface IGenericQueryFactory {

  /**
   * Retrieve a generic query builder, which builds {@link IQueryExpression}s.
   *
   * @return IQueryBuilder for constructing query
   */
  public IQueryBuilder getQueryBuilder();

  /**
   * Convert the given query to a generic one. The query must have been build
   * with a query builder retrieved through this object. Further modifications
   * of the query will not alter the generated {@link IGenericQuery}.
   *
   * @param query to convert to a generic one
   * @return generic query
   * @throws NotSupportedException if query was not created through correct
   *      builder
   */
  public IGenericQuery toGenericQuery(IQueryExpression query)
    throws NotSupportedException;

  /**
   * Transforms a persisted query (obtained from {@link
   * IGenericQueryFactory#fromXml(String)} back into a generic query expression.
   *
   * @param persistedQuery persisted query string
   * @return generic query expression
   * @throws ResourceException if the string could not be transformed into a
   *      valid generic query expression
   */
  public IQueryExpression fromXml(String persistedQuery)
    throws ResourceException;

  /**
   * Transforms a generic query expression into a plain string that can be
   * persisted.
   *
   * @param queryExpression query expression
   * @return query expression as string that can be fed back into {@link
   *      IGenericQueryFactory#fromXml(String)}
   * @throws ResourceException when the query expression could not be persisted
   *      (for instance, when it wasn't obtained from {@link
   *      IGenericQueryFactory#getQueryBuilder()}.
   */
  public String toXml(IQueryExpression queryExpression)
    throws ResourceException;

}

