/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.search;

import com.sapportals.wcm.repository.*;

/**
 * A query expression to be used with every repository manager. <p>
 *
 * Copyright (c) SAP AG 2002-2003
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Revision: 1.3 $
 */
public interface IGenericQuery {

  /**
   * Runs this query and returns a list of resources that matched the criteria.
   * For repositories wihtout a property search manager, a default, simple
   * implementation is used.
   *
   * @param resource to start the query on
   * @param depth maximum depth in resource tree to query
   * @param maxResults maximum number of results wanted
   * @param includeVersions when set to <code>true</code> , also descend into
   *      version histories when present (independantly of depth)
   * @return A list of resource that matched the search criteria
   * @exception ResourceException Exception raised in failure situation
   * @throws NotSupportedException if particular query features are not
   *      supported by the resource
   * @throws AccessDeniedException if there a insufficient permissions on the
   *      resource
   */
  public IResourceList execute(IResource resource, int depth, int maxResults, boolean includeVersions)
    throws ResourceException, AccessDeniedException, NotSupportedException;
}
