/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.search;

import com.sap.tc.logging.Location;
import com.sapportals.wcm.crt.CrtClassLoaderRegistry;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.util.logging.LoggingFormatter;

import java.lang.reflect.InvocationTargetException;

/**
 * Retrieve instance of IGenericQuery. <p>
 *
 * Copyright (c) SAP AG 2002-2003
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Revision: 1.3 $
 */
public final class GenericQueryFactory {

  private final static Location log = Location.getLocation(com.sapportals.wcm.repository.search.GenericQueryFactory.class);

  private static IGenericQueryFactory adapter = null;

  private GenericQueryFactory() { }

  /**
   * Returns a reference to the resource factory instance.
   *
   * @return a reference to the resource factory instance.
   * @exception ResourceException
   */
  public static synchronized IGenericQueryFactory getInstance()
    throws ResourceException {
    if (adapter == null) {
      try {
        Class adapterClass = CrtClassLoaderRegistry.forName("com.sapportals.wcm.repository.search.GenericQueryFactoryImpl");
        GenericQueryFactory.adapter = (IGenericQueryFactory)adapterClass.getMethod("getInstance", null).invoke(null, null);
      }
      catch (InvocationTargetException e) {
        //$JL-EXC$ 
        GenericQueryFactory.log.errorT("getInstance(55)", LoggingFormatter.extractCallstack(e.getTargetException()));
        throw new ResourceException("InvocationTargetException: " + e.getTargetException().getMessage());
      }
      catch (Exception e) {
        throw new ResourceException(e);
      }
    }
    return adapter;
  }
}

