/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;
import com.sapportals.wcm.repository.IResource;

import com.sapportals.wcm.util.events.IEventList;
import com.sapportals.wcm.util.events.IEventMapper;

/**
 * A resource event mapper maps resource events to other resource events. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author paul.goetz@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/api/com/sapportals/wcm/repository/manager/IResourceEventMapper.java#6
 *      $
 */
public interface IResourceEventMapper
   extends IEventMapper {

  /**
   * Map an <code>IResourceEvent</code> to another <code>IResourceEvent</code> .
   * <br>
   * <i>Note</i> : It's a good idea, to pass the original (unmapped) event as
   * the mapped event's parameter.
   *
   * @param event the <code>IResourceEvent</code> to map.
   * @return the mapped <code>IResourceEvent</code> corresponding to the given
   *      resource event or <code>null</code> , if the event is to be ignored
   *      (not mapped).
   */
  public IResourceEvent map(IResourceEvent event);


  /**
   * Get a list of available mapped resource events for a given broker.
   *
   * @param broker the <code>IResourceEventBroker</code> to get the supported
   *      resource events for.
   * @param resource the <code>IResource</code> with the template to get the
   *      events for.
   * @return the <code>IResource EventList</code> with all available mapped
   *      resource events.
   */
  public IEventList getEvents(IResourceEventBroker broker,
    IResource resource);

}
