/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;

import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.util.events.IEventList;
import com.sapportals.wcm.util.events.ITransactionalEventBroker;

/**
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author Markus Breitenfelder
 */
public interface IResourceEventBroker extends ITransactionalEventBroker {

  public IEventList getEvents(IResource resource);

  /**
   * Check if the given type of a <code>ResourceEvent</code> has to be
   * sent at all.
   * @param type the ResourceEvent-type to check for.
   * @return <code>true</code> if at least one receiver is registered for
   *        this <code>ResourceEvent</code> type.
   */
  public boolean mustSendResourceEventType(int type);


}
