/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;

import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.util.events.IEvent;

/**
 * <code>IResourceEvent</code> are objects, which contain a reference about a
 * resource and some additional information, what happened with that resource
 * (e.g. 'was created').
 */
public interface IResourceEvent extends IEvent {

  /**
   * Get a reference to the <code>IResource</code> , that caused the event.
   *
   * @return <code>IResource</code> Resource, that caused the event.
   */
  public IResource getResource();
}
