/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;
import com.sapportals.wcm.crt.configuration.IConfiguration;
import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.repository.manager.*;
import com.sapportals.wcm.repository.service.IRepositoryService;
import com.sapportals.wcm.util.uri.URI;
import java.util.Collection;

import java.util.Properties;

/**
 * A repository manager implements the access to resources of a particular
 * repository. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Revision: 1.13 $
 */
public interface IRepositoryManager {

  /**
   * Get a reference to the security manager for the repository
   *
   * @param resource The resource to manage
   * @return The security manager
   * @exception ResourceException Exception raised in failure situation
   */
  public ISecurityManager getSecurityManager(IResource resource)
    throws ResourceException;

  /**
   * Get a reference to the property search manager for the repository
   *
   * @param resource The resource to manage
   * @return The security manager
   * @exception ResourceException Exception raised in failure situation
   */
  public IPropertySearchManager getPropertySearchManager(IResource resource)
    throws ResourceException;

  /**
   * Returns the prefix config parameter.
   *
   * @return The prefix string
   */
  public String getPrefix();

  /**
   * @return config
   * @deprecated As of EP 5.0 SP5, replaced by {@link #getConfiguration()}
   */
  public Properties getConfig();

  /**
   * Returns the configuration data of this repository manager.
   *
   * @return the configuration data of this repository manager.
   */
  public IConfiguration getConfiguration();

  /**
   * Returns the manager id
   *
   * @return The id
   */
  public String getID();

  /**
   * Returns the description of this manager.
   *
   * @return The description
   */
  public String getDescription();

  /**
   * Returns a reference to this repsitory's event broker
   *
   * @return The event broker instance
   */
  public IResourceEventBroker getEventBroker();

  /**
   * Returns all registered services for this repository
   *
   * @return A collection of IRepositoryServer references
   * @exception ResourceException
   * @deprecated As of EP 5.0 SP5
   */
  public Collection getAllServices()
    throws ResourceException;

  /**
   * Returns a reference to a service for this repository
   *
   * @param type TBD: Description of the incoming method parameter
   * @return IRepositoryService The service reference
   * @exception ResourceException
   * @deprecated As of EP 5.0 SP5, replaced by getService() method in
   *      IRepositoryServiceFactory
   */
  public IRepositoryService getService(String type)
    throws ResourceException;

  /**
   * Checks if a service is avaible.
   *
   * @param type TBD: Description of the incoming method parameter
   * @return serviceAvailable
   * @exception ResourceException
   * @deprecated As of EP 5.0 SP5, replaced by getService() method in
   *      IRepositoryServiceFactory
   */
  public boolean isServiceAvailable(String type)
    throws ResourceException;

  /**
   * Returns a set of supported operations. In case of a null resource, the
   * repository shall return the set of all supported operations.
   *
   * @param resource TBD: Description of the incoming method parameter
   * @return The supported operations
   */
  public ISupportedOptionSet getSupportedOptions(IResource resource);

  /**
   * Returns an object that contains information about the attributes of
   * resource names supported by this repository manager.
   *
   * @return nameInfo
   */
  public NameInfo getNameInfo();
}
