/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;

import com.sapportals.wcm.repository.*;

/**
 * A property search manager provides the capability to search for resources in
 * a repository. <p>
 *
 * Copyright (c) SAP AG 2001-2004
 * @author julian.reschke@greenbytes.de
 * @author stefan.eissing@greenbytes.de
 * @version $Revision: 1.1.1.1 $
 */
public interface IPropertySearchManager {

  /**
   * The manager has special knowledge how to handle this property. This is
   * interesting for a client to know, when queries about special, e.g. live
   * properties like DAV:supported-method-set, are done. In case the search
   * manager does not understand the property, the client might want to test
   * this property himself.
   *
   * @param propName name of property
   * @return true if manager undestands the properties semantics
   */
  public boolean isUnderstood(IPropertyName propName);

  /**
   * Retrieve a search manager specific query builder, which builds a
   * {@link IQueryExpression}.
   *
   * @return IQueryBuilder for constructing query
   */
  public IQueryBuilder getQueryBuilder();


  /**
   * Runs a query and returns a list of resource that matched the criteria. If the query expression 
   * puts conditions on properties, resources to which the current user doesn't have property read
   * access will be excluded from the search.
   *
   * @param query the query object that specifies the search criteria
   * @param resource to start the query on
   * @param depth maximum depth in resource tree to query
   * @param maxResults maximum number of results wanted
   * @param includeVersions when set to <code>true</code> , also descend into
   *      version histories when present (independently of depth)
   * @return A list of resource that matched the search criteria
   */
  public IResourceList execute(IQueryExpression query, IResource resource,
    int depth, int maxResults, boolean includeVersions)
    throws ResourceException, AccessDeniedException, NotSupportedException;

}
