/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;

/**
 * An IPermissionListIterator if an iterator for an IPermissionList
 */
public interface IPermissionListIterator {
  /**
   * check whether there are more entries in the list
   *
   * @return true iff there are more entries in the list
   */
  public boolean hasNext();

  /**
   * get the current element in the list and step to the next element
   *
   * @return the current element in the list
   */
  public IPermission next();
}
