/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;

import java.util.*;
/**
 * An IPermission signifies a basic operation on an object
 */
public interface IPermission {
  // leaf permissions
  public final static String PERMISSION_READ_CONTENT = "leaf_read_content";
  public final static String PERMISSION_READ_PROPERTIES = "leaf_read_properties";
  public final static String PERMISSION_WRITE_CONTENT = "leaf_write_content";
  public final static String PERMISSION_WRITE_PROPERTIES = "leaf_write_properties";
  public final static String PERMISSION_DELETE = "leaf_delete";

  // node permissions
  public final static String PERMISSION_LIST = "node_list_children";
  public final static String PERMISSION_CREATE = "node_create_child";
  public final static String PERMISSION_READ_NODE_PROPERTIES = "node_read_properties";
  public final static String PERMISSION_WRITE_NODE_PROPERTIES = "node_write_properties";
  public final static String PERMISSION_DELETE_NODE = "node_delete";

  /**
   * get the name of the permission
   *
   * @return the name of the permission
   */
  public String getName();

  /**
   * get the description of the permission
   *
   * @return the description of the permission
   */
  public String getDescription();

  public String getDescription(Locale locale);

  /**
   * check whether some permission equals the present permission
   *
   * @param permission the permission to compare to
   * @return true iff the permission equals the present permission
   */
  public boolean equals(IPermission permission);
}
