/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.ResourceException;

import com.sapportals.wcm.repository.manager.IRepositoryManager;
import com.sapportals.wcm.util.uri.RID;

import java.util.Collection;

/**
 * The manager factory creates and manages repository manager instances.
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author frank.renkes@sapportals.com
 * @version $Id:$
 */
public interface IManagerFactory {

  /**
   * Returns a list of all available repository managers
   *
   * @return Collection of IRepositoryManager references
   * @exception ResourceException
   */
  public Collection getAllRepositoryManagers()
    throws ResourceException;

  /**
   * Returns a collection of all available repository managers that are
   * instances of the specified class
   *
   * @param className TBD: Description of the incoming method parameter
   * @return Collection of IRepositoryManager references
   * @exception ResourceException
   */
  public Collection getAllRepositoryManagers(String className)
    throws ResourceException;

  /**
   * Returns the instance of a repository manager for a given ID or <code>null
   * </code>.
   *
   * @param id TBD: Description of the incoming method parameter
   * @return the instance of a repository manager
   * @exception ResourceException Exception raised in failure situation
   */
  public IRepositoryManager getRepositoryManager(String id)
    throws ResourceException;

  /**
   * Returns the repository manager instance for a given resource identifier
   *
   * @param rid TBD: Description of the incoming method parameter
   * @return the repository manager instance
   * @exception ResourceException
   */
  public IRepositoryManager getRepositoryManager(RID rid)
    throws ResourceException;
}
